/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.init.food;

import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.fruitsdelight.compat.diet.DietTagGen;
import dev.xkmc.fruitsdelight.content.item.FDBlockItem;
import dev.xkmc.fruitsdelight.content.item.FDFoodItem;
import dev.xkmc.fruitsdelight.init.FruitsDelight;
import dev.xkmc.fruitsdelight.init.data.TagGen;
import dev.xkmc.fruitsdelight.init.food.EffectEntry;
import dev.xkmc.fruitsdelight.init.food.EffectFunc;
import dev.xkmc.fruitsdelight.init.food.FoodClass;
import dev.xkmc.fruitsdelight.init.food.FruitType;
import dev.xkmc.fruitsdelight.init.food.IFDFood;
import dev.xkmc.fruitsdelight.init.food.IFoodClass;
import dev.xkmc.fruitsdelight.init.registrate.FDBlocks;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public enum FoodType {
    JUICE(FoodClass.GLASS, 1, 0.2f, 10, false, true, TagGen.JUICE, DietTagGen.FRUITS.tag),
    JELLY(FoodClass.JELLY, 4, 0.3f, 20, false, false, TagGen.JELLY, DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    JELLO(FoodClass.BOWL, 1, 0.3f, 20, true, true, TagGen.JELLO, DietTagGen.SUGARS.tag),
    FRUIT(FoodClass.NONE, 4, 0.3f, 5, false, false, DietTagGen.FRUITS.tag),
    SLICE(FoodClass.NONE, 2, 0.3f, 0, true, false, DietTagGen.FRUITS.tag),
    SHEET(FoodClass.NONE, 3, 0.3f, 10, true, false, DietTagGen.FRUITS.tag),
    STICK(FoodClass.STICK, 4, 0.4f, 10, true, false, DietTagGen.FRUITS.tag),
    SWEET(FoodClass.NONE, 8, 0.5f, 20, false, false, DietTagGen.FRUITS.tag, DietTagGen.GRAINS.tag, DietTagGen.SUGARS.tag),
    CREAM(FoodClass.GLASS, 6, 0.5f, 20, false, false, DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    BOWL(FoodClass.BOWL, 8, 0.6f, 30, false, false, DietTagGen.FRUITS.tag),
    MEAL(FoodClass.BOWL, 12, 0.8f, 40, false, false, DietTagGen.FRUITS.tag, DietTagGen.PROTEINS.tag),
    DESSERT(FoodClass.NONE, 5, 0.4f, 20, false, false, DietTagGen.FRUITS.tag, DietTagGen.GRAINS.tag, DietTagGen.SUGARS.tag),
    STAPLE(FoodClass.BOWL, 14, 0.8f, 40, false, false, DietTagGen.FRUITS.tag, DietTagGen.GRAINS.tag, DietTagGen.VEGETABLES.tag),
    ROLL(FoodClass.NONE, 3, 0.4f, 10, true, false, DietTagGen.FRUITS.tag, DietTagGen.SUGARS.tag),
    COOKIE(FoodClass.NONE, 1, 0.3f, 5, true, false, DietTagGen.SUGARS.tag),
    MANGOSTEEN_CAKE((b, p, e) -> new FDBlockItem((Block)FDBlocks.MANGOSTEEN_CAKE.get(), p.m_41495_(Items.f_42399_).m_41487_(16), e), 9, 0.6f, 30, false, false, DietTagGen.FRUITS.tag),
    DURIAN_FLESH(FoodClass.DURIAN_FLESH, 4, 0.3f, 0, false, false, DietTagGen.FRUITS.tag);

    public final int food;
    private final IFoodClass cls;
    private final float sat;
    private final boolean fast;
    private final boolean alwaysEat;
    public final TagKey<Item>[] tags;
    public final int effectLevel;

    @SafeVarargs
    private FoodType(IFoodClass cls, int food, float sat, int effectLevel, boolean fast, boolean alwaysEat, TagKey<Item> ... tags) {
        this.cls = cls;
        this.food = food;
        this.sat = sat;
        this.effectLevel = effectLevel;
        this.fast = fast;
        this.alwaysEat = alwaysEat;
        this.tags = tags;
    }

    public Item build(Item.Properties p, IFDFood type) {
        return this.build(p, type, null);
    }

    public Item build(Item.Properties p, IFDFood type, @Nullable Block block) {
        FoodProperties.Builder val = new FoodProperties.Builder();
        val.m_38760_(this.food).m_38758_(this.sat);
        if (this.fast) {
            val.m_38766_();
        }
        if (this.alwaysEat) {
            val.m_38765_();
        }
        HashSet<Supplier<MobEffect>> set = new HashSet<Supplier<MobEffect>>();
        for (EffectEntry e : type.getEffects()) {
            val.effect(e::getEffect, e.chance());
            set.add(e.eff());
        }
        if (this.effectLevel > 0) {
            for (EffectFunc e : type.fruit().eff) {
                if (set.contains(e.eff())) continue;
                val.effect(() -> e.getEffect(this.effectLevel), e.getChance(this.effectLevel));
            }
        }
        return this.cls.build(block, p.m_41489_(val.m_38767_()), type);
    }

    public <T> ItemBuilder<Item, T> model(ItemBuilder<Item, T> b, int overlay, FruitType fruit) {
        if (overlay > 0) {
            return (ItemBuilder)b.model((ctx, pvd) -> {
                ResourceLocation[] res = new ResourceLocation[overlay + 1];
                res[0] = pvd.modLoc("item/" + ctx.getName());
                for (int i = 1; i <= overlay; ++i) {
                    res[i] = pvd.modLoc("item/" + ctx.getName() + "_filler_" + (i - 1));
                }
                pvd.generated((NonNullSupplier)ctx, res);
            }).color(() -> () -> FDFoodItem::color).transform(e -> e.tab(FruitsDelight.TAB.getKey(), x -> {
                Object patt4262$temp = e.getEntry();
                if (patt4262$temp instanceof FDFoodItem) {
                    FDFoodItem item = (FDFoodItem)patt4262$temp;
                    item.fillItemCategory(overlay, (CreativeModeTabModifier)x);
                }
            }));
        }
        return b.defaultModel();
    }
}

