/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.block;

import gardensofthedead.network.NetworkHandler;
import gardensofthedead.network.WhistleEffectPacket;
import gardensofthedead.platform.PlatformServices;
import gardensofthedead.registry.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WhistlecaneBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty GROWING = BooleanProperty.m_61465_((String)"growing");
    public static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final double GROW_CHANCE = 0.1;
    public static final double WHISTLE_CHANCE = 0.025;
    public static final int MAX_HEIGHT = 6;

    public WhistlecaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GROWING, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.m_60824_(level, pos);
        return SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType pathComputationType) {
        return false;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        return stateBelow.m_60713_((Block)this) || stateBelow.m_204336_(BlockTags.f_13077_) || stateBelow.m_60713_(Blocks.f_50135_) || stateBelow.m_60713_(Blocks.f_50136_);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        int heightAbove = this.getHeightAboveUpToMax((BlockGetter)level, pos);
        int heightBelow = this.getHeightBelowUpToMax((BlockGetter)level, pos);
        BlockState topState = level.m_8055_(pos.m_6630_(heightAbove));
        return heightAbove + heightBelow + 1 < 6 && (Boolean)topState.m_61143_((Property)GROWING) != false;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource randomSource, BlockPos pos, BlockState state) {
        int heightAbove = this.getHeightAboveUpToMax((BlockGetter)level, pos);
        int heightBelow = this.getHeightBelowUpToMax((BlockGetter)level, pos);
        int height = heightAbove + heightBelow + 1;
        int extraHeight = 1 + randomSource.m_188503_(2);
        for (int blocksGrown = 0; blocksGrown < extraHeight; ++blocksGrown) {
            BlockPos grownPos = pos.m_6630_(heightAbove);
            BlockState grownState = level.m_8055_(grownPos);
            if (height >= 6 || !((Boolean)grownState.m_61143_((Property)GROWING)).booleanValue() || !level.m_46859_(grownPos.m_7494_())) {
                return;
            }
            this.growCane((Level)level, grownPos, randomSource, height);
            ++heightAbove;
            ++height;
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (PlatformServices.platformHelper.isSword(player.m_21205_())) {
            return 1.0f;
        }
        return super.m_5880_(state, player, level, pos);
    }

    protected void growCane(Level level, BlockPos pos, RandomSource randomSource, int currentHeight) {
        boolean continueGrowing = currentHeight == 0 || !(randomSource.m_188501_() < 1.0f / (float)(6 - currentHeight));
        BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)GROWING, (Comparable)Boolean.valueOf(continueGrowing));
        level.m_7731_(pos.m_7494_(), newState, 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos abovePos = context.m_8083_().m_7494_();
        BlockState aboveState = context.m_43725_().m_8055_(abovePos);
        return (BlockState)this.m_49966_().m_61124_((Property)GROWING, (Comparable)Boolean.valueOf(!aboveState.m_60713_((Block)this)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    protected int getHeightAboveUpToMax(BlockGetter level, BlockPos pos) {
        int height;
        for (height = 0; height < 6 && level.m_8055_(pos.m_6630_(height + 1)).m_60713_((Block)this); ++height) {
        }
        return height;
    }

    protected int getHeightBelowUpToMax(BlockGetter level, BlockPos pos) {
        int height;
        for (height = 0; height < 6 && level.m_8055_(pos.m_6625_(height + 1)).m_60713_((Block)this); ++height) {
        }
        return height;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GROWING});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos updatedPos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        if (direction == Direction.UP) {
            return (BlockState)this.m_49966_().m_61124_((Property)GROWING, (Comparable)Boolean.valueOf(!newState.m_60713_((Block)this)));
        }
        return super.m_7417_(state, direction, newState, level, pos, updatedPos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)GROWING)).booleanValue()) {
            int height = this.getHeightBelowUpToMax((BlockGetter)level, pos) + 1;
            if (level.m_46859_(pos.m_7494_()) && height < 6 && (double)randomSource.m_188501_() < 0.1) {
                this.growCane((Level)level, pos, randomSource, height);
            }
        } else if ((double)randomSource.m_188501_() < 0.025 && level.m_46859_(pos.m_7494_())) {
            this.whistle(state, level, pos, randomSource);
        }
    }

    private void whistle(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        Vec3 offset = state.m_60824_((BlockGetter)level, pos);
        double x = (double)pos.m_123341_() + offset.f_82479_ + 0.5;
        double z = (double)pos.m_123343_() + offset.f_82481_ + 0.5;
        double y = (double)pos.m_123342_() + offset.f_82480_ + 1.0;
        float volume = 1.0f;
        float pitch = randomSource.m_188501_() * 0.3f + 0.85f;
        level.m_6263_(null, x, y, z, (SoundEvent)ModSoundEvents.WHISTLECANE_WHISTLE.get(), SoundSource.BLOCKS, volume, pitch);
        this.sendWhistlePacket(level, pos);
    }

    private void sendWhistlePacket(ServerLevel level, BlockPos pos) {
        NetworkHandler.sendToTrackingPlayers(level, pos, new WhistleEffectPacket(pos, (Level)level));
    }
}

