/*
 * Decompiled with CFR 0.152.
 */
package com.ecarrascon.orpheus.block;

import com.ecarrascon.orpheus.block.MythosStateEnum;
import com.ecarrascon.orpheus.registry.ItemsRegistry;
import com.ecarrascon.orpheus.util.PlayerUtils;
import com.ecarrascon.orpheus.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MyhtosBlock
extends Block {
    public static final EnumProperty<MythosStateEnum> DIMENSION = EnumProperty.m_61587_((String)"dimension", MythosStateEnum.class);

    public MyhtosBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.OVERWORLD)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level world = pContext.m_43725_();
        if (!world.m_5776_()) {
            if (world.m_46472_().equals((Object)Level.f_46428_)) {
                this.m_49959_((BlockState)this.m_49966_().m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.OVERWORLD)));
            } else if (world.m_46472_().equals((Object)Level.f_46429_)) {
                this.m_49959_((BlockState)this.m_49966_().m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.NETHER)));
            }
        }
        return super.m_5573_(pContext);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.m_5776_()) {
                this.updateBlockStateBasedOnDimension(state, world, pos);
                this.tryGodsCall(world, pos, state, player);
            }
        }
        super.m_141947_(world, pos, state, entity);
    }

    private void updateBlockStateBasedOnDimension(BlockState state, Level world, BlockPos pos) {
        if (world.m_46472_().equals((Object)Level.f_46428_)) {
            world.m_7731_(pos, (BlockState)state.m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.OVERWORLD)), 3);
        } else if (world.m_46472_().equals((Object)Level.f_46429_)) {
            world.m_7731_(pos, (BlockState)state.m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.NETHER)), 3);
        }
    }

    private void tryGodsCall(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.m_46472_().equals((Object)Level.f_46428_)) {
            this.tryCalliopeCall(world, pos, state, player);
        } else if (world.m_46472_().equals((Object)Level.f_46429_)) {
            this.tryOrpheusCall(world, pos, state, player);
        }
    }

    private void tryCalliopeCall(Level world, BlockPos pos, BlockState state, Player player) {
        if (WorldUtils.isSurroundedByBlocksTag(world, pos, (TagKey<Block>)BlockTags.f_13041_, 1)) {
            world.m_7731_(pos, (BlockState)state.m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.OVERWORLD_ACTIVE)), 3);
            if (player.m_21055_((Item)ItemsRegistry.HELLENIC_CODEX.get()) && player.m_6144_()) {
                this.activateCalliopeCall(world, pos, player);
            }
        }
    }

    private void tryOrpheusCall(Level world, BlockPos pos, BlockState state, Player player) {
        if (WorldUtils.isSurroundedByBlocks(world, pos, Blocks.f_50450_, 0)) {
            world.m_7731_(pos, (BlockState)state.m_61124_(DIMENSION, (Comparable)((Object)MythosStateEnum.NETHER_ACTIVE)), 3);
            if (player.m_21055_((Item)ItemsRegistry.APOLLOS_SON.get()) && player.m_6144_()) {
                this.activateOrpheusCall(world, pos, player);
            }
        }
    }

    private void activateCalliopeCall(Level world, BlockPos pos, Player player) {
        WorldUtils.summonLightning(world, player);
        PlayerUtils.decrementHeldItem(player, (Item)ItemsRegistry.HELLENIC_CODEX.get());
        ItemStack calliopesLove = ((Item)ItemsRegistry.CALLIOPES_LOVE.get()).m_7968_();
        if (!player.m_150109_().m_36054_(calliopesLove)) {
            Block.m_49840_((Level)world, (BlockPos)player.m_20183_(), (ItemStack)calliopesLove);
        }
        world.m_46961_(pos, false);
        world.m_5594_(null, pos, SoundEvents.f_12516_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void activateOrpheusCall(Level world, BlockPos pos, Player player) {
        WorldUtils.summonLightning(world, player);
        PlayerUtils.decrementHeldItem(player, (Item)ItemsRegistry.APOLLOS_SON.get());
        ItemStack orpheusLyre = ((Item)ItemsRegistry.ORPHEUS_LYRE.get()).m_7968_();
        if (!player.m_150109_().m_36054_(orpheusLyre)) {
            Block.m_49840_((Level)world, (BlockPos)player.m_20183_(), (ItemStack)orpheusLyre);
        }
        world.m_46961_(pos, false);
        world.m_5594_(null, pos, SoundEvents.f_12516_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DIMENSION});
    }
}

