/*
 * Decompiled with CFR 0.152.
 */
package com.ecarrascon.orpheus.item;

import com.ecarrascon.orpheus.registry.ItemsRegistry;
import com.ecarrascon.orpheus.util.PlayerUtils;
import com.ecarrascon.orpheus.util.WorldUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PandorasPithosItem
extends Item {
    public PandorasPithosItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pLevel.m_5776_() && !pPlayer.m_5833_()) {
            PlayerUtils.decrementHeldItem(pPlayer, (Item)ItemsRegistry.PANDORAS_PITHOS.get());
            WorldUtils.summonLightning(pLevel, pPlayer);
            pPlayer.m_7292_(this.getRandomEffect(pLevel));
            this.getRandomItem(pPlayer, pLevel);
            this.spawnRandomEntity(pPlayer, pLevel);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    private void spawnRandomEntity(Player player, Level world) {
        List<EntityType> possibleEntities = Arrays.asList(EntityType.f_20493_, EntityType.f_20510_);
        EntityType randomEntityType = possibleEntities.get(world.m_213780_().m_216339_(0, possibleEntities.size() - 1));
        int witherPossiblity = world.m_213780_().m_216339_(0, 199);
        if (witherPossiblity == 0) {
            randomEntityType = EntityType.f_20496_;
        }
        int random = world.m_213780_().m_216339_(0, 7);
        for (int i = 0; i < random; ++i) {
            Entity randomEntity = randomEntityType.m_20615_(world);
            if (randomEntity == null) continue;
            randomEntity.m_146884_(player.m_20182_());
            world.m_7967_(randomEntity);
            if (witherPossiblity != 1 || i != 0) continue;
            Cat zeus = this.getZeus(player, world);
            world.m_7967_((Entity)zeus);
        }
    }

    private Cat getZeus(Player player, Level world) {
        Cat zeus = new Cat(EntityType.f_20553_, world);
        zeus.m_6593_(Component.m_130674_((String)"Zeus"));
        zeus.m_21153_(500.0f);
        zeus.m_146915_(true);
        zeus.m_146884_(player.m_20182_());
        return zeus;
    }

    private void getRandomItem(Player player, Level world) {
        List<ItemStack> possibleItems = Arrays.asList(Items.f_42415_.m_7968_(), ((Item)ItemsRegistry.TEARS_OF_HADES.get()).m_7968_(), Items.f_42500_.m_7968_(), Items.f_42398_.m_7968_());
        ItemStack randomItem = possibleItems.get(world.m_213780_().m_216339_(0, possibleItems.size() - 1));
        int random = world.m_213780_().m_216339_(0, 6);
        for (int i = 0; i < random; ++i) {
            ItemStack itemCopy = randomItem.m_41777_();
            if (player.m_150109_().m_36054_(itemCopy)) continue;
            Block.m_49881_((BlockState)player.m_146900_(), (Level)world, (BlockPos)player.m_20183_(), null, null, (ItemStack)itemCopy);
        }
    }

    private MobEffectInstance getRandomEffect(Level pLevel) {
        List<MobEffect> possibleEffects = Arrays.asList(MobEffects.f_19596_, MobEffects.f_19600_, MobEffects.f_19617_, MobEffects.f_19606_, MobEffects.f_19605_, MobEffects.f_19614_, MobEffects.f_19604_, MobEffects.f_19610_, MobEffects.f_19615_, MobEffects.f_19613_);
        MobEffect randomEffect = possibleEffects.get(pLevel.m_213780_().m_216339_(0, possibleEffects.size() - 1));
        return new MobEffectInstance(randomEffect, 1800, 3);
    }
}

