/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.client.entity.model;

import com.modderg.tameablebeasts.server.entity.custom.RacoonEntity;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RacoonModel
extends GeoModel<RacoonEntity> {
    private ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("tameablebeasts", "textures/entity/tameable_racoon.png"), new ResourceLocation("tameablebeasts", "textures/entity/tameable_racoon2.png"), new ResourceLocation("tameablebeasts", "textures/entity/tameable_racoon3.png")};
    private ResourceLocation[] bbytextures = new ResourceLocation[]{new ResourceLocation("tameablebeasts", "textures/entity/tameable_baby_racoon.png"), new ResourceLocation("tameablebeasts", "textures/entity/tameable_baby_racoon2.png"), new ResourceLocation("tameablebeasts", "textures/entity/tameable_baby_racoon3.png")};

    public ResourceLocation getModelResource(RacoonEntity entity) {
        if (entity.m_6162_()) {
            return new ResourceLocation("tameablebeasts", "geo/tameable_baby_racoon.geo.json");
        }
        return new ResourceLocation("tameablebeasts", "geo/tameable_racoon" + (entity.isBellyFull() ? "_fat" : "") + ".geo.json");
    }

    public ResourceLocation getTextureResource(RacoonEntity entity) {
        if (entity.m_6162_()) {
            return this.bbytextures[entity.getTextureID()];
        }
        return this.textures[entity.getTextureID()];
    }

    public ResourceLocation getAnimationResource(RacoonEntity entity) {
        if (entity.m_6162_()) {
            return new ResourceLocation("tameablebeasts", "animations/tameable_baby_racoon.anims.json");
        }
        return new ResourceLocation("tameablebeasts", "animations/tameable_racoon.anims.json");
    }

    public void setCustomAnimations(RacoonEntity animatable, long instanceId, AnimationState<RacoonEntity> animationState) {
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone entity = this.getAnimationProcessor().getBone("entity");
        if (head != null && entity != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float headPitch = entityData.headPitch() * ((float)Math.PI / 180);
            float headYaw = entityData.netHeadYaw() * ((float)Math.PI / 180);
            Quaternionf desiredHeadRotation = new Quaternionf().rotateXYZ(headPitch - entity.getRotX() * 2.0f, headYaw, 0.0f);
            head.setRotX(desiredHeadRotation.x);
            head.setRotY(desiredHeadRotation.y);
            head.setRotZ(desiredHeadRotation.z);
        }
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }
}

