/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.packet.CtoSSyncRiderWantsFlying;
import com.modderg.tameablebeasts.server.entity.FlyingTBAnimal;
import com.modderg.tameablebeasts.server.entity.TBRideable;
import com.modderg.tameablebeasts.server.packet.InitPackets;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FlyingRideableTBAnimal
extends FlyingTBAnimal
implements TBRideable,
PlayerRideableJumping {
    protected final int maxFlyingStamina = 50;
    protected int flyingStamina = 50;
    private int travelCount = 0;
    protected int consumeStaminaModule = 0;
    protected int recoverStaminaModule = 0;
    protected float downMovementAngle = 0.0f;
    protected boolean riderWantsFlying = false;
    protected boolean wasWalking = this.m_20096_();
    public boolean upInput = false;
    public boolean downInput = false;

    public void setRiderWantsFlying(boolean i) {
        this.riderWantsFlying = i;
    }

    public boolean getRiderWantFlying() {
        return !this.m_20197_().isEmpty() && this.riderWantsFlying;
    }

    protected FlyingRideableTBAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        if (this.m_217005_()) {
            this.riderWantsFlying = this.m_20096_();
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SADDLE", this.hasSaddle());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLE, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SADDLE")) {
            this.setSaddle(compound.m_128471_("SADDLE"));
        }
    }

    @Override
    public String getRidingMessage() {
        return this.getJumpKeyName() + " to Ascend, " + this.getCrouchKeyName() + " to Plummet , " + this.getShiftKeyName() + " to Dismount";
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_21830_((LivingEntity)player)) {
            if (this.hasSaddle() && !this.m_6898_(itemstack)) {
                if (!player.m_6144_()) {
                    player.m_20329_((Entity)this);
                    this.messageRiding(player);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            } else if (!this.m_6162_() && this.isSaddle(itemstack)) {
                this.setSaddle(true);
                this.m_5496_(SoundEvents.f_12034_, 0.15f, 1.0f);
                itemstack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected void m_6668_(@NotNull DamageSource p_21192_) {
        this.dropSaddle();
        super.m_6668_(p_21192_);
    }

    @Override
    public void m_7023_(@NotNull Vec3 vec3) {
        if (this.m_6084_()) {
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof Player) {
                boolean tryFlyUp;
                Player passenger = (Player)livingEntity;
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
                this.m_19915_(passenger.m_146908_(), passenger.m_146909_() * 0.5f);
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float x = passenger.f_20900_ * 0.5f;
                float z = passenger.f_20902_ * 0.5f;
                if (z <= 0.0f) {
                    z *= 0.25f;
                }
                this.m_7910_(0.1f);
                boolean bl = tryFlyUp = this.upInput && this.flyingStamina > 0;
                if (this.m_20096_() && !this.wasWalking) {
                    this.wasWalking = true;
                }
                if (tryFlyUp) {
                    this.wasWalking = false;
                }
                if (this.m_9236_().m_5776_() && this.riderWantsFlying == this.wasWalking) {
                    this.riderWantsFlying = !this.wasWalking;
                    InitPackets.sendToServer(new CtoSSyncRiderWantsFlying(this.m_19879_(), !this.wasWalking));
                }
                if (this.wasWalking) {
                    super.m_7023_(new Vec3((double)x, vec3.f_82480_, (double)z));
                    this.travelCountProcess();
                } else {
                    double yMov = (double)(-(this.downInput ? 45.0f : this.downMovementAngle)) * (Math.PI / 180);
                    if (tryFlyUp) {
                        ++this.travelCount;
                        yMov = 0.4363323129985824;
                        if (this.travelCount % this.consumeStaminaModule == 0) {
                            --this.flyingStamina;
                        }
                    }
                    float speed = (float)this.m_21133_(Attributes.f_22280_) * 0.2f;
                    this.f_19788_ = this.f_19788_ > 0.0f ? this.f_19788_ : 0.0f;
                    vec3 = new Vec3((double)x, yMov, (double)z);
                    this.m_19920_(this.applyPotionEffectsToSpeed(speed *= this.getRidingSpeedMultiplier()), vec3);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    if (x == 0.0f && z == 0.0f) {
                        this.m_20256_(this.m_20184_().m_82559_(new Vec3(0.9, 1.0, 0.9)));
                    }
                    if (!this.upInput && this.m_20184_().m_82556_() < 0.1) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, Math.sin((float)this.f_19797_ / 4.0f) * 0.02, 0.0));
                    }
                }
            } else {
                super.m_7023_(vec3);
                this.travelCountProcess();
            }
        }
    }

    @Override
    protected Boolean shouldFly() {
        LivingEntity owner = this.m_269323_();
        return super.shouldFly() != false && (this.getGoalsRequireFlying() && (!this.m_21824_() || this.isWandering()) || !this.m_217005_() && (this.m_5912_() || this.isOverFluidOrVoid()) || this.getRiderWantFlying() || owner != null && (this.m_20270_((Entity)owner) > 10.0f && !this.isWandering() || this.isFlying() && !owner.m_20096_() && !this.m_20363_((Entity)owner)));
    }

    private void travelCountProcess() {
        --this.travelCount;
        if (this.travelCount % this.recoverStaminaModule == 0 && this.flyingStamina < 50) {
            ++this.flyingStamina;
        }
    }

    public float getStaminaScale() {
        return (float)this.flyingStamina * 1.0f / 50.0f;
    }

    public boolean m_7132_() {
        return true;
    }

    public void m_7199_(int o) {
    }

    public void m_8012_() {
    }

    public void m_7888_(int o) {
    }

    public <T extends FlyingRideableTBAnimal> AnimationController<T> glideFlyController(T entity) {
        return new AnimationController(entity, "movement", 10, event -> {
            if (entity.isFlying() && !entity.m_21825_()) {
                if (entity.m_6109_()) {
                    if (entity.downInput) {
                        event.getController().setAnimation(RawAnimation.begin().then("glide_down", Animation.LoopType.LOOP));
                    } else if (entity.upInput) {
                        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
                    } else if (entity.isStill()) {
                        event.getController().setAnimation(RawAnimation.begin().then("fly_idle", Animation.LoopType.LOOP));
                    } else {
                        event.getController().setAnimation(RawAnimation.begin().then("glide", Animation.LoopType.LOOP));
                    }
                } else if (entity.isStill()) {
                    event.getController().setAnimation(RawAnimation.begin().then("fly_idle", Animation.LoopType.LOOP));
                } else {
                    double d = entity.m_20184_().f_82480_;
                    double d2 = entity.m_6109_() ? 0.0 : -0.2;
                    if (d < d2) {
                        event.getController().setAnimation(RawAnimation.begin().then("glide", Animation.LoopType.LOOP));
                    } else {
                        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
                    }
                }
                return PlayState.CONTINUE;
            }
            return this.groundState(entity, event);
        });
    }
}

