/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.server.entity.TBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.navigation.TBFlyingPathNavigation;
import com.modderg.tameablebeasts.server.entity.navigation.TBGroundPathNavigation;
import com.modderg.tameablebeasts.server.packet.InitPackets;
import com.modderg.tameablebeasts.server.packet.StoCSyncFlying;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FlyingTBAnimal
extends TBAnimal {
    protected boolean isFlying = true;
    private static final EntityDataAccessor<Boolean> GOAL_WANT_FLYING = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected LinkedList<MoveControl> moveControlRotation = new LinkedList();
    protected LinkedList<PathNavigation> pathNavigationRotation = new LinkedList();
    protected TBFollowOwnerGoal followOwnerGoal;
    int updateFlyCount = 5;

    public boolean isFlying() {
        return this.isFlying;
    }

    public void setIsFlying(boolean flying) {
        this.isFlying = flying;
    }

    public void setGoalsRequireFlying(boolean i) {
        this.m_20088_().m_135381_(GOAL_WANT_FLYING, (Object)i);
    }

    public boolean getGoalsRequireFlying() {
        return (Boolean)this.m_20088_().m_135370_(GOAL_WANT_FLYING);
    }

    protected FlyingTBAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.m_21441_(BlockPathTypes.WATER, -8.0f);
        this.m_21441_(BlockPathTypes.LAVA, -8.0f);
        this.moveControlRotation.add((MoveControl)new FlyingMoveControl((Mob)this, 20, false));
        this.moveControlRotation.add(new MoveControl((Mob)this));
        this.pathNavigationRotation.add((PathNavigation)new TBFlyingPathNavigation((Mob)this, this.m_9236_()).canFloat(true));
        this.pathNavigationRotation.add((PathNavigation)new TBGroundPathNavigation((Mob)this, this.m_9236_()));
        this.f_21342_ = this.moveControlRotation.getFirst();
        this.f_21344_ = this.pathNavigationRotation.getFirst();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("GOAL_WANT_FLYING", this.getGoalsRequireFlying());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GOAL_WANT_FLYING, (Object)(!this.m_20096_() ? 1 : 0));
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("GOAL_WANT_FLYING")) {
            this.setGoalsRequireFlying(compound.m_128471_("GOAL_WANT_FLYING"));
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.followOwnerGoal = new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f, true);
        this.f_21345_.m_25352_(0, (Goal)this.followOwnerGoal);
    }

    protected Boolean shouldFly() {
        return !this.m_21827_();
    }

    protected void switchNavigation() {
        this.moveControlRotation.addFirst(this.moveControlRotation.removeLast());
        this.pathNavigationRotation.addFirst(this.pathNavigationRotation.removeLast());
        this.f_21342_ = this.moveControlRotation.getFirst();
        this.f_21344_ = this.pathNavigationRotation.getFirst();
        this.isFlying = this.f_21342_ instanceof FlyingMoveControl;
        this.m_20242_(this.isFlying);
        if (this.isFlying) {
            this.f_21343_.m_24901_();
        }
        this.followOwnerGoal.refreshNavigatorPath();
        InitPackets.sendToAll(new StoCSyncFlying(this.m_19879_(), this.isFlying));
    }

    public boolean isStill() {
        return !(this.m_20184_().m_165925_() > 0.001);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_() && this.updateFlyCount++ % 10 == 0 && this.shouldFly().booleanValue() != this.isFlying()) {
            this.switchNavigation();
        }
        super.m_8119_();
    }

    public void m_7023_(@NotNull Vec3 p_218382_) {
        if (this.isFlying() && this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        } else {
            super.m_7023_(p_218382_);
        }
    }

    protected boolean isOverFluidOrVoid() {
        BlockPos position = this.m_20183_();
        Level level = this.m_9236_();
        while (position.m_123342_() > level.m_141937_() && level.m_46859_(position) && level.m_6425_(position).m_76178_()) {
            position = position.m_7495_();
        }
        return !level.m_6425_(position).m_76178_() || position.m_123342_() <= level.m_141937_();
    }

    public boolean m_20068_() {
        return this.isFlying();
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        return false;
    }

    public <T extends FlyingTBAnimal> PlayState flyState(T entity, AnimationState<T> event) {
        if (entity.isStill()) {
            event.getController().setAnimation(RawAnimation.begin().then("fly_idle", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public <T extends FlyingTBAnimal> AnimationController<T> flyController(T entity) {
        return new AnimationController(entity, "movement", 5, event -> {
            if (entity.isFlying()) {
                return this.flyState(entity, event);
            }
            return this.groundState(entity, event);
        });
    }

    public <T extends FlyingTBAnimal> AnimationController<T> justFlyController(T entity) {
        return new AnimationController(entity, "movement", 10, event -> {
            if (!entity.m_21825_() || !entity.isStill()) {
                return this.flyState(entity, event);
            }
            event.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        });
    }
}

