/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.server.entity.TBAnimal;
import com.modderg.tameablebeasts.server.entity.TBRideable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class RideableTBAnimal
extends TBAnimal
implements ItemSteerable,
TBRideable {
    public boolean moving = false;
    Vec3 previousPosition = this.m_20182_();

    protected RideableTBAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SADDLE", this.hasSaddle());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLE, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SADDLE")) {
            this.setSaddle(compound.m_128471_("SADDLE"));
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_21830_((LivingEntity)player)) {
            if (this.hasSaddle() && !this.m_6898_(itemstack)) {
                if (!player.m_6144_()) {
                    player.m_20329_((Entity)this);
                    this.messageRiding(player);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            } else if (!this.m_6162_() && this.isSaddle(itemstack)) {
                this.setSaddle(true);
                this.m_5496_(SoundEvents.f_12034_, 0.15f, 1.0f);
                itemstack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20160_()) {
            this.moving = this.updateMovingState();
        }
    }

    protected void m_6668_(@NotNull DamageSource p_21192_) {
        this.dropSaddle();
        super.m_6668_(p_21192_);
    }

    public void m_7023_(@NotNull Vec3 pos) {
        if (this.m_6084_()) {
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof Player) {
                Player passenger = (Player)livingEntity;
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
                this.m_274367_(1.0f);
                this.m_146922_(passenger.m_146908_());
                this.m_146926_(passenger.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float x = passenger.f_20900_ * 0.5f;
                float z = passenger.f_20902_;
                if (z <= 0.0f) {
                    z *= 0.25f;
                }
                float speedMul = this.getRidingSpeedMultiplier();
                this.m_7910_(this.applyPotionEffectsToSpeed(this.m_21051_(Attributes.f_22279_).m_22115_() * (double)speedMul));
                Vec3 nextPos = new Vec3((double)x, pos.f_82480_, (double)z);
                if (!this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82377_(nextPos.f_82479_, 0.0, nextPos.f_82481_).m_82383_(nextPos))) {
                    this.f_19862_ = true;
                }
                super.m_7023_(nextPos);
            } else {
                super.m_7023_(pos);
            }
        }
    }

    public void superTravel(Vec3 pos) {
        super.m_7023_(pos);
    }

    public boolean m_6746_() {
        return false;
    }

    public <T extends RideableTBAnimal> AnimationController<T> vehicleController(T entity) {
        return new AnimationController(entity, "movement", 3, event -> this.vehicleState(entity, event));
    }

    public <T extends RideableTBAnimal> PlayState vehicleState(T entity, AnimationState<T> event) {
        if (entity.m_20160_()) {
            if (entity.moving) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return this.groundState(entity, event);
    }

    public boolean updateMovingState() {
        Vec3 currentPosition = this.m_20182_();
        boolean flag = !currentPosition.equals((Object)this.previousPosition);
        this.previousPosition = currentPosition;
        return flag;
    }
}

