/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.server.entity.FlyingTBAnimal;
import com.modderg.tameablebeasts.server.entity.navigation.TBGroundPathNavigation;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TBAnimal
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> TEXTURE_ID = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WANDERING = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> GOALS_WANT_RUNNING = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected List<String> attackAnims = new ArrayList<String>();
    protected int textureIdSize = 0;
    protected int healthFloor = 0;
    protected AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public void setTextureId(int i) {
        this.m_20088_().m_135381_(TEXTURE_ID, (Object)i);
    }

    public int getTextureID() {
        return (Integer)this.m_20088_().m_135370_(TEXTURE_ID);
    }

    public void setWandering(boolean i) {
        this.m_20088_().m_135381_(WANDERING, (Object)i);
    }

    public boolean isWandering() {
        return (Boolean)this.m_20088_().m_135370_(WANDERING);
    }

    public void setRunning(boolean i) {
        this.m_20088_().m_135381_(GOALS_WANT_RUNNING, (Object)i);
        this.updateAttributes();
    }

    public boolean isRunning() {
        return (Boolean)this.m_20088_().m_135370_(GOALS_WANT_RUNNING);
    }

    protected TBAnimal(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.updateAttributes();
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TEXTURE_ID", this.getTextureID());
        compound.m_128379_("WANDERING", this.isWandering());
        compound.m_128379_("GOALS_WANT_RUNNING", this.isWandering());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TEXTURE_ID, (Object)0);
        this.f_19804_.m_135372_(WANDERING, (Object)false);
        this.f_19804_.m_135372_(GOALS_WANT_RUNNING, (Object)false);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("TEXTURE_ID")) {
            this.setTextureId(compound.m_128451_("TEXTURE_ID"));
        }
        if (compound.m_128441_("WANDERING")) {
            this.setWandering(compound.m_128471_("WANDERING"));
        }
        if (compound.m_128441_("GOALS_WANT_RUNNING")) {
            this.setWandering(compound.m_128471_("GOALS_WANT_RUNNING"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6779_(@NotNull LivingEntity target) {
        if (target instanceof TBAnimal) {
            TBAnimal tg = (TBAnimal)target;
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player p = (Player)livingEntity;
                if (tg.m_21830_((LivingEntity)p)) return false;
            }
        }
        if (!super.m_6779_(target)) return false;
        return true;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance p_146747_, @NotNull MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        if (this.textureIdSize > 0) {
            this.setTextureId(this.f_19796_.m_188503_(this.textureIdSize));
        }
        this.updateAttributes();
        if (this.healthFloor > 0) {
            float health = this.generateRandomMaxHealth(this.healthFloor);
            this.m_21051_(Attributes.f_22276_).m_22100_((double)health);
            this.m_21153_(health);
        }
        return super.m_6518_(levelAccessor, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.f_19797_ % 240 == 0) {
            this.m_5634_(1.0f);
        }
        super.m_8107_();
    }

    protected float generateRandomMaxHealth(int floor) {
        RandomSource random = this.m_217043_();
        return floor + random.m_188503_(8) + random.m_188503_(9);
    }

    public void updateAttributes() {
    }

    protected void addGoals(Goal ... goals) {
        int i = 0;
        for (Goal goal : goals) {
            this.f_21345_.m_25352_(++i, goal);
        }
    }

    protected void addTargetGoals(Goal ... goals) {
        int i = 0;
        for (Goal goal : goals) {
            this.f_21346_.m_25352_(++i, goal);
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        FlyingTBAnimal flyAnimal;
        TBAnimal tBAnimal;
        if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
            if (!this.m_21825_() && !this.isWandering()) {
                this.setWandering(true);
                this.messageState("wandering", player);
            } else {
                this.setWandering(false);
                this.messageState(this.m_21825_() ? "following" : "sitting", player);
                this.m_21837_(!this.m_21827_());
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(player.m_21120_(hand))) {
            this.m_5634_(5.0f);
        }
        if (!(this.m_21825_() || (tBAnimal = this) instanceof FlyingTBAnimal && (flyAnimal = (FlyingTBAnimal)tBAnimal).isFlying())) {
            this.triggerAnim("movement", "interact");
        }
        this.m_5496_(this.getInteractSound(), 0.45f, 1.0f);
        return super.m_6071_(player, hand);
    }

    public boolean m_21827_() {
        return !this.m_20160_() && super.m_21827_();
    }

    public boolean m_21825_() {
        return !this.m_20160_() && super.m_21825_();
    }

    public void m_21837_(boolean p_21838_) {
        this.m_7355_(this.m_20097_(), this.m_9236_().m_8055_(this.m_20097_()));
        super.m_21837_(p_21838_);
    }

    public boolean isTameFood(ItemStack itemStack) {
        return false;
    }

    public void tameGAnimal(Player player, ItemStack itemStack, int chance) {
        if (!player.m_150110_().f_35937_ && itemStack != null) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(100) < chance && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21816_(player.m_20148_());
            this.m_7105_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            this.m_5496_(this.getTameSound(), 0.15f, 1.0f);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
    }

    public EggBlockItem getEgg() {
        return null;
    }

    public boolean breedDropsEgg() {
        return this.getEgg() != null && this.m_21824_();
    }

    public int genChildTextId() {
        if (this.f_19796_.m_188503_(100) <= 30) {
            return this.f_19796_.m_188503_(this.textureIdSize);
        }
        return this.getTextureID();
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mob) {
        if (!this.breedDropsEgg()) {
            super.m_27563_(level, mob);
            return;
        }
        this.m_19998_((ItemLike)this.getEgg());
        super.m_277117_(level, mob, null);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel p_146743_, @NotNull AgeableMob p_146744_) {
        if (!this.m_21824_()) {
            TBAnimal animal = (TBAnimal)this.m_6095_().m_20615_(this.m_9236_());
            animal.setTextureId(this.genChildTextId());
            return animal;
        }
        return null;
    }

    public LivingEntity m_6688_() {
        LivingEntity passenger;
        Object e;
        if (!this.m_20197_().isEmpty() && (e = this.m_20197_().get(0)) instanceof LivingEntity && this.m_21830_(passenger = (LivingEntity)e)) {
            return passenger;
        }
        return null;
    }

    @NotNull
    public PathNavigation m_6037_(@NotNull Level p_21480_) {
        return new TBGroundPathNavigation((Mob)this, this.m_9236_());
    }

    public void setMoveControl(MoveControl control) {
        this.f_21342_ = control;
    }

    public void setPathNavigation(PathNavigation navigation) {
        this.f_21344_ = navigation;
    }

    public SoundEvent getTameSound() {
        return null;
    }

    public SoundEvent getInteractSound() {
        return null;
    }

    public void messageState(String txt, Player player) {
        if (player instanceof LocalPlayer) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)txt), false);
        }
    }

    public void spawnItemParticles(ItemStack p_21061_, int p_21062_, Entity animal) {
        for (int i = 0; i < p_21062_; ++i) {
            Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-animal.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-animal.m_146908_() * ((float)Math.PI / 180));
            double d0 = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-animal.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-animal.m_146908_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(animal.m_20185_(), animal.m_20188_(), animal.m_20189_());
            if (animal.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)animal.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                continue;
            }
            animal.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    public <T extends TBAnimal> AnimationController<T> groundController(T entity) {
        return new AnimationController(entity, "movement", 5, event -> this.groundState(entity, event));
    }

    public boolean m_7327_(@NotNull Entity p_21372_) {
        if (!this.attackAnims.isEmpty()) {
            this.playAttackAnim();
        }
        return super.m_7327_(p_21372_);
    }

    public void playAttackAnim() {
        this.triggerAnim("movement", "attack");
    }

    public AnimationController<?> addAnimationTriggers(AnimationController<?> controller) {
        for (String attack : this.attackAnims) {
            controller.triggerableAnim(attack, RawAnimation.begin().then(attack, Animation.LoopType.PLAY_ONCE));
        }
        controller.triggerableAnim("interact", RawAnimation.begin().then("interact", Animation.LoopType.PLAY_ONCE));
        return controller;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public <T extends TBAnimal> PlayState groundState(T entity, AnimationState<T> event) {
        if (event.isMoving() || entity.m_6147_()) {
            event.getController().setAnimation(RawAnimation.begin().then(entity.isRunning() ? "run" : "walk", Animation.LoopType.LOOP));
        } else if (entity.m_21825_()) {
            event.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }
}

