/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.custom;

import com.modderg.tameablebeasts.client.entity.CustomJumpMeter;
import com.modderg.tameablebeasts.client.sound.SoundInit;
import com.modderg.tameablebeasts.server.ModCommonConfigs;
import com.modderg.tameablebeasts.server.entity.FlyingRideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.FlyFromNowAndThenGoal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.InitPOITypes;
import com.modderg.tameablebeasts.server.entity.goals.NoFlyRandomStrollGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.ItemInit;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import com.modderg.tameablebeasts.server.tags.TBTags;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GrapteranodonEntity
extends FlyingRideableTBAnimal
implements CustomJumpMeter {
    public boolean playGrip = false;
    public boolean eatEmote = false;

    public GrapteranodonEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.textureIdSize = 5;
        this.healthFloor = 15;
        this.attackAnims.add("attack");
        this.consumeStaminaModule = 4;
        this.recoverStaminaModule = 9;
        this.downMovementAngle = 10.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.225).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 48.0).m_22266_(Attributes.f_22288_);
    }

    public static boolean checkGrapteraSpawnRules(EntityType<GrapteranodonEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return GrapteranodonEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && (Boolean)ModCommonConfigs.CAN_SPAWN_GRAPTERA.get() != false;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, InitPOITypes.GRAPTERANODON_POI), new TameablePanicGoal((PathfinderMob)this, 1.25), new NoFlyRandomStrollGoal(this, 1.0), new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(TBTags.Items.GRAPTERA_FOOD), false), new FlyFromNowAndThenGoal(this), new TBFollowParentGoal(this, 1.0), new BreedGoal((Animal)this, 1.0), new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new FloatGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new HurtByTargetGoal((PathfinderMob)this, new Class[0]), new OwnerHurtTargetGoal((TamableAnimal)this), new OwnerHurtByTargetGoal((TamableAnimal)this)});
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameGAnimal(player, itemstack, 33);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item itemSaddle() {
        return (Item)ItemInit.QUETZAL_SADDLE.get();
    }

    @Override
    public Item hatBoostItem() {
        return (Item)ItemInit.FLYING_HELMET.get();
    }

    public boolean m_6898_(ItemStack p_27600_) {
        boolean isFood = p_27600_.m_204117_(TBTags.Items.GRAPTERA_FOOD);
        if (isFood) {
            this.eatEmote = true;
        }
        return isFood;
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        boolean isFood;
        boolean bl = isFood = this.m_21223_() < 5.0f && itemStack.m_204117_(TBTags.Items.GRAPTERA_TAME_FOOD);
        if (isFood) {
            this.eatEmote = true;
        }
        return isFood;
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)ItemInit.GRAPTERANODON_EGG_ITEM.get());
    }

    @Override
    public float getRidingSpeedMultiplier() {
        if (this.m_20069_()) {
            return 0.5f;
        }
        LivingEntity passenger = this.m_6688_();
        if (passenger instanceof Player) {
            Player p = (Player)passenger;
            if (this.hatBoostItem() != null && this.isHatBoostItem(p.m_150109_().m_36052_(3))) {
                return 1.2f;
            }
        }
        return 0.8f;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.2;
    }

    public void tryGrabbing() {
        if (!this.isFlying()) {
            return;
        }
        if (this.m_20197_().size() >= 2) {
            ((Entity)this.m_20197_().get(1)).m_8127_();
            return;
        }
        this.playGrip = true;
        AABB boundingBox = this.m_20191_().m_82400_(2.0);
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, boundingBox, entity -> entity != this);
        nearbyEntities.stream().findFirst().ifPresent(pickedUp -> pickedUp.m_20329_((Entity)this));
    }

    protected void m_19956_(@NotNull Entity entity, @NotNull Entity.MoveFunction moveFunction) {
        if (this.m_20197_().size() >= 2 && ((Entity)this.m_20197_().get(1)).equals((Object)entity)) {
            double d0 = this.m_20186_() + this.m_6048_() + entity.m_6049_() - 0.4;
            moveFunction.m_20372_(entity, this.m_20185_(), d0 - (double)entity.m_20206_(), this.m_20189_());
        } else {
            super.m_19956_(entity, moveFunction);
        }
    }

    protected boolean m_7310_(@NotNull Entity p_20354_) {
        return this.m_20197_().size() <= 1;
    }

    public boolean m_20096_() {
        boolean onGround = super.m_20096_();
        if (onGround && this.m_20197_().size() >= 2) {
            ((Entity)this.m_20197_().get(1)).m_8127_();
        }
        return onGround;
    }

    public boolean shouldRiderSit() {
        return super.shouldRiderSit();
    }

    @Override
    public String getRidingMessage() {
        return super.getRidingMessage() + ", Left Click to Grab";
    }

    @Override
    public ResourceLocation getStaminaSpriteLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/graptera_stamina.png");
    }

    @Override
    public ResourceLocation getStaminaBackgroundLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/graptera_stamina_back.png");
    }

    @Override
    public Vec2 getStaminaSpriteDimensions() {
        return new Vec2(43.0f, 29.0f);
    }

    @Override
    public float getStaminaHeight() {
        float f = this.flyingStamina;
        Objects.requireNonNull(this);
        return f / 50.0f;
    }

    public SoundEvent m_7515_() {
        if (this.isFlying()) {
            return (SoundEvent)SoundInit.GRAPTERA_FLY.get();
        }
        this.eatEmote = true;
        return (SoundEvent)SoundInit.QUETZAL_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        this.eatEmote = true;
        return (SoundEvent)SoundInit.GRAPTERA_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        this.eatEmote = true;
        return (SoundEvent)SoundInit.GRAPTERA_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)SoundInit.CHIKOTE_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        this.eatEmote = true;
        return (SoundEvent)SoundInit.GRAPTERA_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        this.eatEmote = true;
        return (SoundEvent)SoundInit.GRAPTERA_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.addAnimationTriggers(this.glideFlyController(this))});
        controllers.add(new AnimationController[]{this.legsMouthController(this)});
    }

    public <T extends FlyingRideableTBAnimal> AnimationController<T> legsMouthController(T entity) {
        return new AnimationController(entity, "legs&mouthController", 10, event -> {
            AnimationController controller = event.getController();
            if (this.playGrip) {
                controller.setAnimation(RawAnimation.begin().then("leg_grab", Animation.LoopType.PLAY_ONCE));
                this.playGrip = false;
                controller.forceAnimationReset();
            }
            if (this.eatEmote) {
                controller.setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
                this.eatEmote = false;
                controller.forceAnimationReset();
            }
            return PlayState.CONTINUE;
        });
    }
}

