/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.custom;

import com.modderg.tameablebeasts.client.sound.SoundInit;
import com.modderg.tameablebeasts.server.ModCommonConfigs;
import com.modderg.tameablebeasts.server.entity.RideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.InitPOITypes;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.ItemInit;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import com.modderg.tameablebeasts.server.tags.TBTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GrasshopperEntity
extends RideableTBAnimal
implements PlayerRideableJumping {
    protected float playerJumpPendingScale = 0.0f;
    boolean allowStandSliding = true;
    protected int jumpCount = this.f_19796_.m_216339_(100, 200);
    protected boolean isJumping = false;

    @Override
    public Item itemSaddle() {
        return (Item)ItemInit.GRASSHOPPER_SADDLE.get();
    }

    public GrasshopperEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.textureIdSize = 4;
        this.healthFloor = 20;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22288_, 2.5);
    }

    public static boolean checkGrasshopperSpawnRules(EntityType<GrasshopperEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return GrasshopperEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && (Boolean)ModCommonConfigs.CAN_SPAWN_GRASSHOPPER.get() != false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new TameablePanicGoal((PathfinderMob)this, 1.2), new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FloatGoal((Mob)this), new SitWhenOrderedToGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, InitPOITypes.GRASSHOPPER_POI), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTags.Items.GRASSHOPPER_FOOD), false), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new TameablePanicGoal((PathfinderMob)this, 1.25), new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10), new BreedGoal((Animal)this, 1.0), new TBFollowParentGoal(this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f)});
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameGAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public String getRidingMessage() {
        return this.getJumpKeyName() + " to Jump, " + this.getShiftKeyName() + " to Dismount";
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTags.Items.GRASSHOPPER_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTags.Items.GRASSHOPPER_TAME_FOOD);
    }

    @Override
    public void m_8119_() {
        if (this.jumpCount >= 0) {
            --this.jumpCount;
        }
        super.m_8119_();
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        return false;
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)ItemInit.GRASSHOPPER_EGG_ITEM.get());
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.GRASSHOPPER_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.GRASSHOPPER_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)SoundInit.GRASSHOPPER_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)SoundInit.GRASSHOPPER_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)SoundInit.GRASSHOPPER_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)SoundInit.GRASSHOPPER_INTERACT.get();
    }

    @Override
    public float getRidingSpeedMultiplier() {
        if (!this.m_20096_()) {
            return 2.0f;
        }
        return 0.9f;
    }

    @Override
    public void m_7023_(Vec3 vec333) {
        if (this.m_6084_()) {
            LivingEntity livingEntity;
            if (!this.m_21824_() && this.jumpCount == 0 && this.m_20096_()) {
                this.m_6135_();
                this.m_5496_((SoundEvent)SoundInit.GRASSHOPPER_JUMP.get(), 0.15f, 1.0f);
                this.jumpCount = this.f_19796_.m_216339_(20, 150);
            }
            if ((livingEntity = this.m_6688_()) instanceof Player) {
                Player passenger = (Player)livingEntity;
                this.m_146922_(passenger.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(passenger.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = passenger.f_20900_ * 0.25f;
                float f1 = passenger.f_20902_ / 2.0f;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_20096_() && this.playerJumpPendingScale == 0.0f && !this.allowStandSliding) {
                    f = 0.0f;
                    f1 = 0.0f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.m_20096_()) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + (double)this.m_6118_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1 * (double)0.7f, vec3.f_82481_);
                    this.setIsJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-1.5f * f2 * this.playerJumpPendingScale), 0.0, (double)(1.5f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    super.superTravel(new Vec3((double)f, vec333.f_82480_, (double)f1));
                } else if (passenger instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.m_20096_()) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.m_146872_();
            } else {
                super.superTravel(vec333);
            }
        }
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean b) {
        this.isJumping = b;
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    protected float m_6118_() {
        if (this.jumpCount == 0) {
            this.jumpCount = this.f_19796_.m_216339_(100, 200);
            return 0.84f * this.m_20098_();
        }
        return super.m_6118_();
    }

    @Override
    public void updateAttributes() {
        if (this.m_6162_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.15);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        }
    }

    public void m_7888_(int p_21696_) {
        if (this.hasSaddle()) {
            if (p_21696_ < 0) {
                p_21696_ = 0;
            } else {
                this.allowStandSliding = true;
            }
            this.playerJumpPendingScale = p_21696_ >= 90 ? 1.0f : 0.4f + 0.4f * (float)p_21696_ / 90.0f;
        }
    }

    public boolean m_7132_() {
        return this.hasSaddle();
    }

    public void m_7199_(int p_21695_) {
        this.m_5496_((SoundEvent)SoundInit.GRASSHOPPER_JUMP.get(), 0.15f, 1.0f);
    }

    public void m_8012_() {
    }

    public <T extends RideableTBAnimal> AnimationController<T> jumpController(T entity) {
        return new AnimationController(entity, "movement", 2, event -> {
            if (!entity.m_20096_() && entity.m_20184_().f_82480_ > 0.0) {
                event.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return this.groundState(entity, event);
        });
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(this.jumpController(this))});
    }
}

