/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.custom;

import com.modderg.tameablebeasts.client.sound.SoundInit;
import com.modderg.tameablebeasts.server.entity.TBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.InitPOITypes;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.item.ItemInit;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import com.modderg.tameablebeasts.server.tags.TBTags;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class GroundBeetleEntity
extends TBAnimal
implements GeoEntity,
NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;

    public GroundBeetleEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.textureIdSize = 2;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 20.0);
    }

    public static boolean checkGroundBeetleSpawnRules(EntityType<GroundBeetleEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FleeSunGoal((PathfinderMob)this, 3.0), new TakeCareOfEggsGoal((Animal)this, 15, InitPOITypes.GROUND_BEETLE_POI), new FloatGoal((Mob)this), new LeapAtTargetGoal((Mob)this, 0.4f), new SitWhenOrderedToGoal((TamableAnimal)this), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTags.Items.GROUND_BEETLE_FOOD), false), new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new BreedGoal((Animal)this, 1.0), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new OwnerHurtByTargetGoal((TamableAnimal)this), new HurtByTargetGoal((PathfinderMob)this, new Class[0]), new OwnerHurtTargetGoal((TamableAnimal)this)});
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.updateAttributes();
            this.tameGAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTags.Items.GROUND_BEETLE_FOOD);
    }

    public boolean m_6898_(ItemStack p_27600_) {
        return p_27600_.m_204117_(TBTags.Items.GROUND_BEETLE_TAME_FOOD);
    }

    @Override
    public AgeableMob m_142606_(@NotNull ServerLevel p_146743_, @NotNull AgeableMob p_146744_) {
        return null;
    }

    @Override
    public void updateAttributes() {
        if (this.m_6162_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.1);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
        }
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)ItemInit.GROUND_BEETLE_EGG_ITEM.get());
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.BEETLE_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.BEETLE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)SoundInit.BEETLE_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)SoundInit.BEETLE_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)SoundInit.BEETLE_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)SoundInit.BEETLE_INTERACT.get();
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(this.groundController(this))});
    }
}

