/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.custom;

import com.modderg.tameablebeasts.client.entity.CustomJumpMeter;
import com.modderg.tameablebeasts.client.sound.SoundInit;
import com.modderg.tameablebeasts.server.ModCommonConfigs;
import com.modderg.tameablebeasts.server.entity.FlyingRideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.TBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.FlyFromNowAndThenGoal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.InitPOITypes;
import com.modderg.tameablebeasts.server.entity.goals.NoFlyRandomStrollGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.ItemInit;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import com.modderg.tameablebeasts.server.tags.TBTags;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class QuetzalcoatlusEntity
extends FlyingRideableTBAnimal
implements CustomJumpMeter {
    private static final EntityDataAccessor<Boolean> STAND = SynchedEntityData.m_135353_(TBAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public void setStand(boolean i) {
        this.m_20088_().m_135381_(STAND, (Object)i);
    }

    public boolean hasStand() {
        return (Boolean)this.m_20088_().m_135370_(STAND);
    }

    public QuetzalcoatlusEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.textureIdSize = 6;
        this.healthFloor = 30;
        this.attackAnims.add("attack");
        this.consumeStaminaModule = 14;
        this.recoverStaminaModule = 8;
        this.downMovementAngle = 8.0f;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 48.0).m_22266_(Attributes.f_22288_);
    }

    public static boolean checkQuetzalSpawnRules(EntityType<QuetzalcoatlusEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return QuetzalcoatlusEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && (Boolean)ModCommonConfigs.CAN_SPAWN_QUETZAL.get() != false;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, InitPOITypes.QUETZAL_POI), new TameablePanicGoal((PathfinderMob)this, 1.25), new NoFlyRandomStrollGoal(this, 1.0), new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(TBTags.Items.QUETZAL_FOOD), false), new FlyFromNowAndThenGoal(this), new TBFollowParentGoal(this, 1.0), new BreedGoal((Animal)this, 1.0), new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new FloatGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new OwnerHurtByTargetGoal((TamableAnimal)this), new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]), new OwnerHurtTargetGoal((TamableAnimal)this)});
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameGAnimal(player, itemstack, 33);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && !this.m_6162_() && itemstack.m_150930_((Item)ItemInit.QUETZAL_STAND.get())) {
            this.setStand(true);
            this.m_5496_(SoundEvents.f_12034_, 0.15f, 1.0f);
            itemstack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.hasStand() && !this.m_21830_((LivingEntity)player) && !this.m_21825_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("STAND", this.hasStand());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STAND, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("STAND")) {
            this.setStand(compound.m_128471_("STAND"));
        }
    }

    @Override
    public Item itemSaddle() {
        return (Item)ItemInit.QUETZAL_SADDLE.get();
    }

    @Override
    public Item hatBoostItem() {
        return (Item)ItemInit.FLYING_HELMET.get();
    }

    public boolean m_6898_(ItemStack p_27600_) {
        return p_27600_.m_204117_(TBTags.Items.QUETZAL_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return this.m_21223_() < 5.0f && itemStack.m_204117_(TBTags.Items.QUETZAL_TAME_FOOD);
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)ItemInit.QUETZAL_EGG_ITEM.get());
    }

    public void m_6863_(boolean p_146756_) {
        this.m_146762_(p_146756_ ? -48000 : 0);
    }

    protected void m_19956_(@NotNull Entity rider, @NotNull Entity.MoveFunction p_19958_) {
        if (((Entity)this.m_20197_().get(0)).equals((Object)rider)) {
            super.m_19956_(rider, p_19958_);
        } else if (((Entity)this.m_20197_().get(1)).equals((Object)rider)) {
            this.positionWithOffSets(rider, 0.9f, -0.7f, 1.1f, 0.9f);
        } else if (((Entity)this.m_20197_().get(2)).equals((Object)rider)) {
            this.positionWithOffSets(rider, 0.9f, 0.7f, 1.1f, 0.9f);
        } else {
            this.positionWithOffSets(rider, 0.6f, 0.0f, 1.0f, 0.9f);
        }
    }

    public void positionWithOffSets(Entity rider, float xOffset, float zOffset, float yMovingOffSet, float yStillOffSet) {
        double cos = Math.cos((double)this.m_146908_() * (Math.PI / 180));
        double sin = Math.sin((double)this.m_146908_() * (Math.PI / 180));
        double offsetX = sin * (double)xOffset;
        double offsetZ = cos * (double)(-xOffset);
        double offsetX2 = cos * (double)zOffset;
        double offsetZ2 = sin * (double)zOffset;
        rider.m_6034_(this.m_20185_() + offsetX + offsetX2, this.m_20186_() + rider.m_6049_() + (double)(this.isFlying() ? yMovingOffSet : yStillOffSet), this.m_20189_() + offsetZ + offsetZ2);
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        return this.m_20197_().size() < 5 && this.hasStand() && !this.m_20197_().isEmpty() || this.m_21830_((LivingEntity)entity) && super.m_7310_(entity);
    }

    @Override
    protected void m_6668_(@NotNull DamageSource p_21192_) {
        if (this.hasStand()) {
            this.m_19998_((ItemLike)ItemInit.QUETZAL_STAND.get());
        }
        super.m_6668_(p_21192_);
    }

    @Override
    public float getRidingSpeedMultiplier() {
        if (this.m_20069_()) {
            return 0.4f;
        }
        LivingEntity passenger = this.m_6688_();
        if (passenger instanceof Player) {
            Player p = (Player)passenger;
            if (this.hatBoostItem() != null && this.isHatBoostItem(p.m_150109_().m_36052_(3))) {
                return 1.0f;
            }
        }
        return 0.6f;
    }

    @Override
    public ResourceLocation getStaminaSpriteLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/quetzal_stamina.png");
    }

    @Override
    public ResourceLocation getStaminaBackgroundLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/quetzal_stamina_back.png");
    }

    @Override
    public Vec2 getStaminaSpriteDimensions() {
        return new Vec2(53.0f, 40.0f);
    }

    @Override
    public float getStaminaHeight() {
        float f = this.flyingStamina;
        Objects.requireNonNull(this);
        return f / 50.0f;
    }

    public SoundEvent m_7515_() {
        if (this.isFlying()) {
            return (SoundEvent)SoundInit.QUETZAL_FLY.get();
        }
        return (SoundEvent)SoundInit.QUETZAL_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.QUETZAL_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)SoundInit.QUETZAL_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)SoundInit.QUETZAL_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)SoundInit.QUETZAL_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)SoundInit.QUETZAL_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(this.glideFlyController(this))});
    }
}

