/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.goals;

import com.modderg.tameablebeasts.server.entity.TBAnimal;
import com.modderg.tameablebeasts.server.entity.custom.ScarecrowAllayEntity;
import com.modderg.tameablebeasts.server.entity.goals.InitPOITypes;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class RaidCropsTameableGoal
extends Goal {
    TBAnimal mob;
    int radius;
    BlockPos targetPos;
    int checkTimer;
    int raidTimer = 60;
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();

    public RaidCropsTameableGoal(TBAnimal mob, int radius) {
        this.mob = mob;
        this.radius = radius;
        this.checkTimer = mob.m_217043_().m_188503_(40);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.checkTimer++ % 40 != 0) {
            return false;
        }
        if (this.mob.m_21824_()) {
            return false;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.mob.m_9236_(), (Entity)this.mob)) {
            return false;
        }
        return !this.mob.m_21824_() && this.hasCropsToRaid() && this.areNotScarecrowBlocksNearBy() && this.areNotScareCrowsNearby();
    }

    public boolean m_8045_() {
        if (this.checkTimer++ % 40 != 0) {
            return true;
        }
        return this.targetPos != null && this.mob.m_9236_().m_8055_(this.targetPos).m_60734_() instanceof CropBlock && this.areNotScarecrowBlocksNearBy() && this.areNotScareCrowsNearby();
    }

    public void m_8041_() {
        this.targetPos = null;
    }

    public void m_8037_() {
        if (--this.raidTimer < 0) {
            this.mob.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 1.0);
        }
        if (this.targetPos != null && this.mob.m_20238_(this.targetPos.m_252807_()) <= 2.5) {
            this.mob.triggerAnim("movement", "eat_crop");
            this.mob.m_9236_().m_46961_(this.targetPos, false);
            this.mob.m_216990_(SoundEvents.f_11912_);
            this.targetPos = null;
            this.raidTimer = 60;
        }
    }

    private boolean areNotScareCrowsNearby() {
        List list = this.mob.m_9236_().m_45971_(ScarecrowAllayEntity.class, TARGETING_CONDITIONS, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(10.0));
        return list.isEmpty();
    }

    private boolean areNotScarecrowBlocksNearBy() {
        Level level = this.mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PoiManager poiManager = serverLevel.m_8904_();
            Optional poiPos = poiManager.m_27186_(p_217376_ -> p_217376_.m_203373_(InitPOITypes.SCARECROW_POI.getId()), pos -> true, this.mob.m_20183_(), 48, PoiManager.Occupancy.ANY);
            return poiPos.isEmpty();
        }
        return false;
    }

    private boolean hasCropsToRaid() {
        BlockPos entityPos = this.mob.m_20183_();
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int y = -this.radius; y <= this.radius; ++y) {
                for (int z = -this.radius; z <= this.radius; ++z) {
                    CropBlock crop;
                    BlockPos currentPos = entityPos.m_7918_(x, y, z);
                    BlockState state = this.mob.m_9236_().m_8055_(currentPos);
                    Block currentBlock = state.m_60734_();
                    if (!(currentBlock instanceof CropBlock) || !(crop = (CropBlock)currentBlock).m_52307_(state)) continue;
                    this.targetPos = currentPos;
                    return true;
                }
            }
        }
        return false;
    }
}

