/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.goals;

import com.modderg.tameablebeasts.server.entity.TBAnimal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class TBFollowOwnerGoal
extends Goal {
    private final Level level;
    private final TBAnimal mob;
    private LivingEntity owner;
    private final double speedModifier;
    private int timeToRecalcPath = 0;
    private PathNavigation navigation;
    private boolean canFly = false;
    private boolean swims = false;
    private float oldWaterCost;
    private final float startDistance;
    private final float stopDistance;

    public TBFollowOwnerGoal(TBAnimal mob, double p_25295_, float p_25296_, float p_25297_, boolean flies, boolean swims) {
        this(mob, p_25295_, p_25296_, p_25297_, flies);
        this.swims = swims;
    }

    public TBFollowOwnerGoal(TBAnimal mob, double p_25295_, float p_25296_, float p_25297_, boolean flies) {
        this(mob, p_25295_, p_25296_, p_25297_);
        this.canFly = flies;
    }

    public TBFollowOwnerGoal(TBAnimal mob, double p_25295_, float p_25296_, float p_25297_) {
        this.level = mob.m_9236_();
        this.mob = mob;
        this.owner = mob.m_269323_();
        this.speedModifier = p_25295_;
        this.navigation = mob.m_21573_();
        this.startDistance = p_25296_;
        this.stopDistance = p_25297_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_269323_();
        if (livingentity == null || this.mob.isWandering() || livingentity.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.mob.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_() || this.mob.isWandering()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.mob.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.mob.m_21827_() || this.mob.m_20159_() || this.mob.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.mob.m_20280_((Entity)this.owner) >= 144.0) {
                this.teleportToOwner();
            }
            this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
        if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
            return false;
        }
        this.mob.m_7678_((double)p_25304_ + 0.5, p_25305_, (double)p_25306_ + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos p_25308_) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)p_25308_.m_122032_());
        BlockState blockstate = this.level.m_8055_(p_25308_.m_7495_());
        if (this.swims ? blockpathtypes != BlockPathTypes.WALKABLE && !blockstate.m_60713_(Blocks.f_49990_) : (this.canFly ? blockpathtypes != BlockPathTypes.WALKABLE && !blockstate.m_60713_(Blocks.f_50016_) : blockpathtypes != BlockPathTypes.WALKABLE || blockstate.m_60734_() instanceof LeavesBlock)) {
            return false;
        }
        BlockPos blockpos = p_25308_.m_121996_((Vec3i)this.mob.m_20183_());
        return this.level.m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.mob.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
    }

    public void refreshNavigatorPath() {
        this.navigation = this.mob.m_21573_();
    }
}

