/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity.goals;

import com.modderg.tameablebeasts.server.block.EggBlockEntity;
import com.modderg.tameablebeasts.server.entity.goals.InitPOITypes;
import com.modderg.tameablebeasts.server.packet.InitPackets;
import com.modderg.tameablebeasts.server.packet.StoCLoveEggPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class TakeCareOfEggsGoal
extends Goal {
    Animal mob;
    List<RegistryObject<PoiType>> targetEggs = List.of(InitPOITypes.CHIKOTE_POI, InitPOITypes.ARGENTAVIS_POI, InitPOITypes.GRASSHOPPER_POI, InitPOITypes.CRESTED_GECKO_POI, InitPOITypes.PENGUIN_POI, InitPOITypes.GRAPTERANODON_POI, InitPOITypes.FLYING_BEETLE_POI, InitPOITypes.GROUND_BEETLE_POI, InitPOITypes.QUETZAL_POI, InitPOITypes.ROLY_POLY_POI);
    int radius;
    BlockPos targetPos;
    int doScan;

    public TakeCareOfEggsGoal(Animal mob, int radius) {
        this.mob = mob;
        this.radius = radius;
        this.doScan = mob.m_217043_().m_188503_(40);
    }

    public TakeCareOfEggsGoal(Animal mob, int radius, RegistryObject<PoiType> specificEgg) {
        this(mob, radius);
        this.targetEggs = List.of(specificEgg);
    }

    public boolean m_8036_() {
        TamableAnimal tamable;
        Animal animal;
        if (this.doScan-- <= 0) {
            this.targetPos = this.hasEggToTakeCareOff();
            this.doScan = this.mob.m_217043_().m_188503_(80);
        }
        if ((animal = this.mob) instanceof TamableAnimal && (tamable = (TamableAnimal)animal).m_21827_()) {
            return false;
        }
        return !this.mob.m_5912_() && this.targetPos != null;
    }

    public boolean m_8045_() {
        TamableAnimal tamable;
        Animal animal;
        return this.targetPos != null && this.mob.m_9236_().m_7702_(this.targetPos) instanceof EggBlockEntity && (!((animal = this.mob) instanceof TamableAnimal) || !(tamable = (TamableAnimal)animal).m_21827_());
    }

    public void m_8041_() {
        this.targetPos = null;
    }

    public void m_8037_() {
        BlockEntity blockEntity;
        this.mob.m_274367_(1.5f);
        Level level = this.mob.m_9236_();
        if (this.mob.m_20238_(this.targetPos.m_252807_()) < 4.0 && (blockEntity = level.m_7702_(this.targetPos)) instanceof EggBlockEntity) {
            EggBlockEntity egg = (EggBlockEntity)blockEntity;
            egg.goBadTimer = 3000;
            InitPackets.sendToAll(new StoCLoveEggPacket(this.targetPos));
            this.m_8041_();
        } else {
            Vec3 center = this.targetPos.m_252807_();
            double targetY = center.f_82480_ + 1.5;
            this.mob.m_21573_().m_26519_(center.f_82479_, targetY, center.f_82481_, (double)1.1f);
        }
    }

    private BlockPos hasEggToTakeCareOff() {
        Level level = this.mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PoiManager poiManager = serverLevel.m_8904_();
            for (RegistryObject<PoiType> poiT : this.targetEggs) {
                Optional poiPos = poiManager.m_27186_(poiType -> poiType.m_203373_(poiT.getId()), pos -> {
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (!(blockEntity instanceof EggBlockEntity)) return false;
                    EggBlockEntity egg = (EggBlockEntity)blockEntity;
                    if (egg.goBadTimer >= 2700) return false;
                    if (egg.goBadTimer <= 0) return false;
                    return true;
                }, this.mob.m_20183_(), 48, PoiManager.Occupancy.ANY);
                if (!poiPos.isPresent()) continue;
                return (BlockPos)poiPos.get();
            }
        }
        return null;
    }
}

