/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.decorations;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;

public abstract class StackedBlock
extends BaseBlock {
    private final Lazy<Integer> minValue = Lazy.of(() -> StackedBlock.getMinValue(this.getStackSizeProperty()));
    private final Lazy<Integer> maxValue = Lazy.of(() -> StackedBlock.getMaxValue(this.getStackSizeProperty()));

    public StackedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)this.getStackSizeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public abstract IntegerProperty getStackSizeProperty();

    protected boolean isForStack(ItemStack stack) {
        return stack.m_150930_(this.m_5456_());
    }

    @Nullable
    protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
        IntegerProperty property;
        BlockPos pos;
        Level level;
        BlockState blockState;
        if ((placementBlockState = super.modifyPlacementState(placementBlockState, ctx)) != null && (blockState = (level = ctx.m_43725_()).m_8055_(pos = ctx.m_8083_())).m_61138_((Property)(property = this.getStackSizeProperty()))) {
            Integer current = (Integer)blockState.m_61143_((Property)property);
            int amount = Math.min((Integer)this.maxValue.get(), current + 1);
            if (amount != current || amount != (Integer)placementBlockState.m_61143_((Property)property)) {
                placementBlockState = (BlockState)placementBlockState.m_61124_((Property)property, (Comparable)Integer.valueOf(amount));
                for (int i = 0; i < 5; ++i) {
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
        return placementBlockState;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext ctx) {
        IntegerProperty property = this.getStackSizeProperty();
        if (!blockState.m_61138_((Property)property)) {
            return false;
        }
        return !ctx.m_7078_() && this.isForStack(ctx.m_43722_()) && (Integer)blockState.m_61143_((Property)property) < (Integer)this.maxValue.get() || super.m_6864_(blockState, ctx);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.isForStack(stack)) {
            IntegerProperty stackSizeProperty = this.getStackSizeProperty();
            Integer count = (Integer)blockState.m_61143_((Property)stackSizeProperty);
            Integer minValue = (Integer)this.minValue.get();
            int newCount = count - 1;
            if (newCount < minValue) {
                ItemStack poppedStack = this.getPoppedStack(level, pos, blockState, minValue, player, hand);
                level.m_46953_(pos, false, (Entity)player);
                if (!player.m_7500_()) {
                    StackedBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)poppedStack);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            BlockState newBlockState = (BlockState)blockState.m_61124_((Property)stackSizeProperty, (Comparable)Integer.valueOf(newCount));
            BlockHelper.playBreakSound((Level)level, (BlockPos)pos, (Entity)player);
            if (!player.m_7500_()) {
                ItemStack poppedStack = this.getPoppedStack(level, pos, newBlockState, newCount, player, hand);
                StackedBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)poppedStack);
            }
            for (int i = 0; i < 5; ++i) {
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, newBlockState), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
            level.m_46597_(pos, newBlockState);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(blockState, level, pos, player, hand, hit);
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)FACING_4_WAY);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)this.getStackSizeProperty());
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)this.getStackableTranslation().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public MutableComponent getStackableTranslation() {
        return Component.m_237115_((String)this.getStackableTranslationKey());
    }

    protected ItemStack getPoppedStack(Level level, BlockPos pos, BlockState blockState, int count, Player player, InteractionHand hand) {
        return new ItemStack((ItemLike)this);
    }

    public final String getStackableTranslationKey() {
        return "%s.stacked".formatted(this.m_7705_());
    }

    public static int getMinValue(IntegerProperty property) {
        return property.m_6908_().stream().mapToInt(i -> i).filter(i -> i <= 0).min().orElse(0);
    }

    public static int getMaxValue(IntegerProperty property) {
        return property.m_6908_().stream().mapToInt(i -> i).filter(i -> i >= 0).max().orElse(0);
    }

    public static abstract class Dyeable
    extends StackedBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MapColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MapColor defaultColor) {
            MapColor mapColor = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, mapColor);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Override
        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        @Override
        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        @Override
        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }

        @Override
        protected ItemStack getPoppedStack(Level level, BlockPos pos, BlockState blockState, int count, Player player, InteractionHand hand) {
            ItemStack stack = super.getPoppedStack(level, pos, blockState, count, player, hand);
            return IDyeable.getCloneItemStack(blockState, (BlockGetter)level, pos, stack);
        }
    }
}

