/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.fabric.state.properties;

import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_3542;
import net.minecraft.class_4990;

public enum Orientation implements class_3542
{
    X_POSITIVE("x_positive", class_2350.class_2351.field_11048),
    X_MIDDLE("x_middle", class_2350.class_2351.field_11048),
    X_NEGATIVE("x_negative", class_2350.class_2351.field_11048),
    Z_POSITIVE("z_positive", class_2350.class_2351.field_11051),
    Z_MIDDLE("z_middle", class_2350.class_2351.field_11051),
    Z_NEGATIVE("z_negative", class_2350.class_2351.field_11051),
    Y_POSITIVE("y_positive", class_2350.class_2351.field_11052),
    Y_MIDDLE("y_middle", class_2350.class_2351.field_11052),
    Y_NEGATIVE("y_negative", class_2350.class_2351.field_11052);

    private final String name;
    public final class_2350.class_2351 axis;

    private Orientation(String name, class_2350.class_2351 axis) {
        this.name = name;
        this.axis = axis;
    }

    public boolean isMiddle() {
        return this == X_MIDDLE || this == Z_MIDDLE || this == Y_MIDDLE;
    }

    public boolean isPositive() {
        return this == X_POSITIVE || this == Z_POSITIVE || this == Y_POSITIVE;
    }

    public boolean isNegative() {
        return this == X_NEGATIVE || this == Z_NEGATIVE || this == Y_NEGATIVE;
    }

    public Orientation rotate(class_2470 rotation) {
        if (this.axis == class_2350.class_2351.field_11052) {
            return this;
        }
        return switch (rotation) {
            case class_2470.field_11463 -> this.getClockWise();
            case class_2470.field_11464 -> this.getOpposite();
            case class_2470.field_11465 -> this.getCounterClockWise();
            default -> this;
        };
    }

    public Orientation mirror(class_2415 mirror) {
        class_4990 rotation = mirror.method_26380();
        if (rotation == class_4990.field_23323 && this.axis == class_2350.class_2351.field_11048) {
            return this.getOpposite();
        }
        if (rotation == class_4990.field_23267 && this.axis == class_2350.class_2351.field_11051) {
            return this.getOpposite();
        }
        if (rotation == class_4990.field_23266 && this.axis == class_2350.class_2351.field_11052) {
            return this.getOpposite();
        }
        return this;
    }

    public Orientation getClockWise() {
        return switch (this) {
            case Z_NEGATIVE -> X_POSITIVE;
            case Z_POSITIVE -> X_NEGATIVE;
            case X_NEGATIVE -> Z_NEGATIVE;
            case X_POSITIVE -> Z_POSITIVE;
            case X_MIDDLE -> Z_MIDDLE;
            case Z_MIDDLE -> X_MIDDLE;
            default -> this;
        };
    }

    public Orientation getCounterClockWise() {
        return switch (this) {
            case Z_NEGATIVE -> X_NEGATIVE;
            case Z_POSITIVE -> X_POSITIVE;
            case X_NEGATIVE -> Z_POSITIVE;
            case X_POSITIVE -> Z_NEGATIVE;
            case X_MIDDLE -> Z_MIDDLE;
            case Z_MIDDLE -> X_MIDDLE;
            default -> this;
        };
    }

    public Orientation getOpposite() {
        return switch (this) {
            case Z_NEGATIVE -> Z_POSITIVE;
            case Z_POSITIVE -> Z_NEGATIVE;
            case X_NEGATIVE -> X_POSITIVE;
            case X_POSITIVE -> X_NEGATIVE;
            case Y_POSITIVE -> Y_NEGATIVE;
            case Y_NEGATIVE -> Y_POSITIVE;
            default -> this;
        };
    }

    public static Orientation getOrientationFrom(class_1750 context) {
        class_2350.class_2351 axis = context.method_8038().method_10166();
        if (axis.method_10179()) {
            return Orientation.getYOrientationFrom(context.method_8037(), context.method_17698());
        }
        if (context.method_8042().method_10166() == class_2350.class_2351.field_11048) {
            return Orientation.getXOrientationFrom(context.method_8037(), context.method_17698());
        }
        if (context.method_8042().method_10166() == class_2350.class_2351.field_11051) {
            return Orientation.getZOrientationFrom(context.method_8037(), context.method_17698());
        }
        return Y_MIDDLE;
    }

    public static Orientation getXZOrientationFrom(class_1750 context) {
        if (context.method_8042().method_10166() == class_2350.class_2351.field_11048) {
            return Orientation.getXOrientationFrom(context.method_8037(), context.method_17698());
        }
        if (context.method_8042().method_10166() == class_2350.class_2351.field_11051) {
            return Orientation.getZOrientationFrom(context.method_8037(), context.method_17698());
        }
        return Z_MIDDLE;
    }

    private static Orientation getZOrientationFrom(class_2338 clickPosition, class_243 clickLocation) {
        double p = clickLocation.field_1350 - (double)clickPosition.method_10260();
        if (p > 0.6666666666666666) {
            return Z_POSITIVE;
        }
        if (p > 0.3333333333333333) {
            return Z_MIDDLE;
        }
        return Z_NEGATIVE;
    }

    private static Orientation getXOrientationFrom(class_2338 clickPosition, class_243 clickLocation) {
        double p = clickLocation.field_1352 - (double)clickPosition.method_10263();
        if (p > 0.6666666666666666) {
            return X_POSITIVE;
        }
        if (p > 0.3333333333333333) {
            return X_MIDDLE;
        }
        return X_NEGATIVE;
    }

    private static Orientation getYOrientationFrom(class_2338 clickPosition, class_243 clickLocation) {
        double p = clickLocation.field_1351 - (double)clickPosition.method_10264();
        if (p > 0.6666666666666666) {
            return Y_NEGATIVE;
        }
        if (p > 0.3333333333333333) {
            return Y_MIDDLE;
        }
        return Y_POSITIVE;
    }

    public String method_15434() {
        return this.name;
    }
}

