/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.forge.compat;

import com.fizzware.dramaticdoors.forge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.forge.compat.Compats;
import com.fizzware.dramaticdoors.forge.forge.config.DDConfigForge;
import com.fizzware.dramaticdoors.forge.tags.DDBlockTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;

public class AutomaticDoorCompat {
    protected static int doorOpenTime = DDConfigForge.getConfigIntValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.doorOpenTime");
    protected static boolean shouldOpenIronDoors = DDConfigForge.getConfigBooleanValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.shouldOpenIronDoors");
    protected static boolean preventOpeningOnSneak = DDConfigForge.getConfigBooleanValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.preventOpeningOnSneak");
    public static HashMap<Level, List<BlockPos>> toclosedoors = new HashMap();
    public static HashMap<Level, List<BlockPos>> newclosedoors = new HashMap();
    private static List<BlockPos> runnables = new ArrayList<BlockPos>();

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load e) {
        if (!Compats.AUTOMATIC_DOORS_INSTALLED) {
            return;
        }
        Level world = (Level)e.getLevel();
        if (world == null || world.f_46443_) {
            return;
        }
        doorOpenTime = DDConfigForge.getConfigIntValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.doorOpenTime");
        shouldOpenIronDoors = DDConfigForge.getConfigBooleanValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.shouldOpenIronDoors");
        preventOpeningOnSneak = DDConfigForge.getConfigBooleanValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("automaticdoors-common.toml"), "General.preventOpeningOnSneak");
        toclosedoors.put(world, new ArrayList());
        newclosedoors.put(world, new ArrayList());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent e) {
        if (!Compats.AUTOMATIC_DOORS_INSTALLED) {
            return;
        }
        Level world = e.level;
        if (world.f_46443_ || e.phase != TickEvent.Phase.START) {
            return;
        }
        if (newclosedoors.size() > 0) {
            toclosedoors.get(world).addAll((Collection<BlockPos>)newclosedoors.get(world));
            newclosedoors.get(world).clear();
        }
        if (toclosedoors.size() > 0) {
            ArrayList<BlockPos> closetoremove = new ArrayList<BlockPos>();
            for (BlockPos bp : toclosedoors.get(world)) {
                if (bp == null) {
                    closetoremove.add(bp);
                    continue;
                }
                BlockState state = world.m_8055_(bp);
                Block block = state.m_60734_();
                if (!(block instanceof TallDoorBlock) || !AutomaticDoorCompat.isDoorHandOpenable(state)) {
                    closetoremove.add(bp);
                    continue;
                }
                boolean canclose = true;
                for (Player player : world.m_45976_(Player.class, new AABB((double)(bp.m_123341_() - 2), (double)bp.m_123342_(), (double)(bp.m_123343_() - 2), (double)(bp.m_123341_() + 2), (double)bp.m_123342_(), (double)(bp.m_123343_() + 2)))) {
                    BlockPos ppos = player.m_20183_();
                    if (!ppos.m_123314_((Vec3i)bp, 3.0) || preventOpeningOnSneak && player.m_6047_()) continue;
                    canclose = false;
                    break;
                }
                if (!canclose) continue;
                for (BlockPos aroundpos : BlockPos.m_121976_((int)(bp.m_123341_() - 1), (int)bp.m_123342_(), (int)(bp.m_123343_() - 1), (int)(bp.m_123341_() + 1), (int)bp.m_123342_(), (int)(bp.m_123343_() + 1))) {
                    BlockState aroundstate = world.m_8055_(aroundpos);
                    Block aroundblock = aroundstate.m_60734_();
                    if (!(aroundblock instanceof TallDoorBlock) || !AutomaticDoorCompat.isDoorHandOpenable(state)) continue;
                    ((TallDoorBlock)block).setOpen(null, world, aroundstate, aroundpos, false);
                }
                closetoremove.add(bp);
            }
            if (closetoremove.size() > 0) {
                for (BlockPos tr : closetoremove) {
                    toclosedoors.get(world).remove(tr);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        Level world = player.m_20193_();
        if (world.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (player.m_6144_() && preventOpeningOnSneak) {
            return;
        }
        BlockPos ppos = player.m_20183_().m_7494_().m_7949_();
        for (BlockPos np : BlockPos.m_121976_((int)(ppos.m_123341_() - 1), (int)ppos.m_123342_(), (int)(ppos.m_123343_() - 1), (int)(ppos.m_123341_() + 1), (int)ppos.m_123342_(), (int)(ppos.m_123343_() + 1))) {
            BlockState state = world.m_8055_(np);
            Block block = state.m_60734_();
            if (!(block instanceof TallDoorBlock) || !AutomaticDoorCompat.isDoorHandOpenable(state) || toclosedoors.get(world).contains(np) || newclosedoors.get(world).contains(np)) continue;
            ((TallDoorBlock)block).setOpen((Entity)player, world, state, np, true);
            AutomaticDoorCompat.delayDoorClose(world, np.m_7949_());
        }
    }

    public static void delayDoorClose(Level world, BlockPos pos) {
        if (pos == null) {
            return;
        }
        if (runnables.contains(pos)) {
            return;
        }
        runnables.add(pos);
        new Thread(() -> {
            try {
                Thread.sleep(doorOpenTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!toclosedoors.get(world).contains(pos) && !newclosedoors.get(world).contains(pos)) {
                newclosedoors.get(world).add(pos);
            }
            runnables.remove(pos);
        }).start();
    }

    private static boolean isDoorHandOpenable(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof TallDoorBlock) {
            if (((TallDoorBlock)block).type().f_278463_()) {
                return true;
            }
            if (!((TallDoorBlock)block).type().f_278463_() && state.m_204336_(DDBlockTags.HAND_OPENABLE_TALL_METAL_DOORS)) {
                return true;
            }
        }
        return shouldOpenIronDoors;
    }
}

