/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies.datagen;

import io.github.sirjain0.perfectplushies.init.BlockInit;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "perfectplushies", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        BlockInit.plushieBlocks.stream().map(Supplier::get).forEach(this::generatePlushieBlockState);
        BlockInit.playerBlocks.stream().map(Supplier::get).forEach(this::generatePlayerPlushieBlockState);
        this.generatePlayerPlushieBlockState(BlockInit.DUMBO_BLOB_PLUSHIE.get());
    }

    protected void simpleCubeBottomTopBlockState(Block block) {
        this.simpleBlock(block, (ModelFile)this.blockCubeTopModel(block));
    }

    protected BlockModelBuilder blockCubeTopModel(Block block) {
        String name = this.getName(block);
        return (BlockModelBuilder)this.models().cubeBottomTop(name, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_bottom"), this.modLoc("block/" + name + "_top"));
    }

    private void generatePlayerPlushieBlockState(Block block) {
        ResourceLocation textRL = this.modLoc("block/" + this.getName(block));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.getName(block))).texture("particle", textRL);
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)builder)});
    }

    private void generatePlushieBlockState(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc("block/" + this.getName(block)))).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    protected String getName(Block item) {
        return ForgeRegistries.BLOCKS.getKey((Object)item).m_135815_();
    }
}

