/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies.datagen;

import com.google.common.collect.ImmutableMap;
import io.github.sirjain0.perfectplushies.init.BlockInit;
import io.github.sirjain0.perfectplushies.init.EntityInit;
import io.github.sirjain0.perfectplushies.init.ItemInit;
import io.github.sirjain0.perfectplushies.registration.RegistryObject;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public class ModLangProvider
extends LanguageProvider {
    protected static final String COMMUNITY_PILLAR_STR = "Community Pillar";
    protected static final Map<String, String> REPLACE_LIST = ImmutableMap.of((Object)"tnt", (Object)"TNT", (Object)"sus", (Object)"", (Object)"sizableshrimp", (Object)"SizableShrimp", (Object)"gamerpotion", (Object)"GamerPotion", (Object)"sirjain", (Object)"SirJain", (Object)"rocris", (Object)"RoCris", (Object)"rare", (Object)"", (Object)"epic", (Object)"");

    public ModLangProvider(PackOutput gen) {
        super(gen, "perfectplushies", "en_us");
    }

    protected void addTranslations() {
        ItemInit.ITEMS.getEntries().forEach(this::itemLang);
        EntityInit.ENTITIES.getEntries().forEach(this::entityLang);
        BlockInit.BLOCKS.getEntries().forEach(this::blockLang);
        this.add("itemGroup.perfectplushies.tab", "Perfect Plushies");
        this.add("tooltip.perfectplushies.advanced", "Hold %s for more information");
        this.add("tooltip.perfectplushies.shift", "SHIFT");
        this.add("plushie.description.tslat_plushie", "Developer of Advent of Ascension\nDeveloper of SmartBrainLib\nMaintainer of Geckolib");
        this.add("plushie.description.nyf_plushie", "Co-Developer of Perfect Plushies\nDeveloper of Many Mods that Start with \"Nyf's\"");
        this.add("plushie.description.sizableshrimp_plushie", "NeoForge Developer\nVery Helpful Dev in the Community");
        this.add("plushie.description.gamerpotion_plushie", "Developer of DarkRPG ModPack!");
        this.add("plushie.description.gamerpotion_plushie_rare", "Developer of the DarkRPG ModPack!");
        this.add("plushie.description.silk_plushie", "Pillar of the Modding Community!");
        this.add("plushie.description.june_plushie", "Developer of Plushables");
        this.add("plushie.description.daniel_plushie", "Developer of Spray Madness");
        this.add("plushie.description.sirjain_plushie", "Co-Developer of Perfect Plushies\nCo-Developer of Herespawn\nDeveloper of Throwable Fluids");
        this.add("plushie.description.sirjain_plushie_rare", "Co-Developer of Perfect Plushies\nCo-Developer of Herespawn\nDeveloper of Throwable Fluids");
        this.add("plushie.description.joosh_plushie", "Lead Artist of Bonsai Studios");
        this.add("plushie.description.rocris_plushie", "Community Pillar\nDeveloper of Blaster Movement");
        this.add("plushie.description.geode_plushie", COMMUNITY_PILLAR_STR);
    }

    protected void itemLang(RegistryObject<Item> entry) {
        if (!(entry.get() instanceof BlockItem) || entry.get() instanceof ItemNameBlockItem) {
            this.addItem(entry, this.checkReplace(entry));
        }
    }

    protected void blockLang(RegistryObject<Block> entry) {
        this.addBlock(entry, this.checkReplace(entry));
    }

    protected void entityLang(RegistryObject<EntityType<?>> entry) {
        this.addEntityType(entry, this.checkReplace(entry));
    }

    protected String checkReplace(RegistryObject<?> registryObject) {
        return Arrays.stream(registryObject.getId().m_135815_().split("_")).map(this::checkReplace).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }

    protected String checkReplace(String string) {
        return REPLACE_LIST.containsKey(string) ? REPLACE_LIST.get(string) : StringUtils.capitalize((String)string);
    }
}

