/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies.entity.spawning;

import io.github.sirjain0.perfectplushies.api.PlushieTraderLevelData;
import io.github.sirjain0.perfectplushies.config.CommonConfig;
import io.github.sirjain0.perfectplushies.entity.WanderingPlushieTrader;
import io.github.sirjain0.perfectplushies.init.EntityInit;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;

public class WanderingPlushieTraderSpawner
implements CustomSpawner {
    private final RandomSource random = RandomSource.m_216327_();
    private final ServerLevelData serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public WanderingPlushieTraderSpawner(ServerLevelData pServerLevelData) {
        this.serverLevelData = pServerLevelData;
        this.tickDelay = (Integer)CommonConfig.INSTANCE.TRADER_DEFAULT_TICK_DELAY.get();
        this.spawnDelay = ((PlushieTraderLevelData)pServerLevelData).getWanderingPlushieTraderSpawnDelay();
        this.spawnChance = ((PlushieTraderLevelData)pServerLevelData).getWanderingPlushieTraderSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = (Integer)CommonConfig.INSTANCE.TRADER_DEFAULT_SPAWN_DELAY.get();
            ((PlushieTraderLevelData)pServerLevelData).setWanderingPlushieTraderSpawnDelay(this.spawnDelay);
            this.spawnChance = (Integer)CommonConfig.INSTANCE.TRADER_MIN_SPAWN_CHANCE.get();
            ((PlushieTraderLevelData)pServerLevelData).setWanderingPlushieTraderSpawnChance(this.spawnChance);
        }
    }

    public int m_7995_(ServerLevel pLevel, boolean pSpawnHostiles, boolean pSpawnPassives) {
        if (!pLevel.m_46469_().m_46207_(GameRules.f_46125_)) {
            return 0;
        }
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = (Integer)CommonConfig.INSTANCE.TRADER_DEFAULT_TICK_DELAY.get();
        this.spawnDelay -= ((Integer)CommonConfig.INSTANCE.TRADER_DEFAULT_TICK_DELAY.get()).intValue();
        ((PlushieTraderLevelData)this.serverLevelData).setWanderingPlushieTraderSpawnDelay(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return 0;
        }
        this.spawnDelay = (Integer)CommonConfig.INSTANCE.TRADER_DEFAULT_SPAWN_DELAY.get();
        if (!pLevel.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = Mth.m_14045_((int)(this.spawnChance + (Integer)CommonConfig.INSTANCE.TRADER_SPAWN_CHANCE_INCREASE.get()), (int)((Integer)CommonConfig.INSTANCE.TRADER_MIN_SPAWN_CHANCE.get()), (int)((Integer)CommonConfig.INSTANCE.TRADER_MAX_SPAWN_CHANCE.get()));
        ((PlushieTraderLevelData)this.serverLevelData).setWanderingPlushieTraderSpawnChance(this.spawnChance);
        if (this.random.m_188503_(100) > i) {
            return 0;
        }
        if (this.spawn(pLevel)) {
            this.spawnChance = (Integer)CommonConfig.INSTANCE.TRADER_MIN_SPAWN_CHANCE.get();
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel pServerLevel) {
        ServerPlayer player = pServerLevel.m_8890_();
        if (player == null) {
            return true;
        }
        if (this.random.m_188503_(((Integer)CommonConfig.INSTANCE.TRADER_SPAWN_ONE_IN_X_CHANCE.get()).intValue()) != 0) {
            return false;
        }
        BlockPos blockpos = player.m_20183_();
        int i = 48;
        PoiManager poimanager = pServerLevel.m_8904_();
        Optional optional = poimanager.m_27186_(p_219713_ -> p_219713_.m_203565_(PoiTypes.f_218061_), p_219711_ -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findSpawnPositionNear((LevelReader)pServerLevel, blockpos1, 48);
        if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)pServerLevel, blockpos2)) {
            if (pServerLevel.m_204166_(blockpos2).m_203656_(BiomeTags.f_215807_)) {
                return false;
            }
            WanderingPlushieTrader wanderingtrader = (WanderingPlushieTrader)EntityInit.WANDERING_PLUSHIH_TRADER.get().m_262496_(pServerLevel, blockpos2, MobSpawnType.EVENT);
            if (wanderingtrader != null) {
                this.serverLevelData.m_8115_(wanderingtrader.m_20148_());
                wanderingtrader.m_35891_(48000);
                wanderingtrader.m_35883_(blockpos1);
                wanderingtrader.m_21446_(blockpos1, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader pLevel, BlockPos pPos, int pMaxDistance) {
        BlockPos blockpos = null;
        for (int i = 0; i < (Integer)CommonConfig.INSTANCE.TRADER_NUMBER_OF_SPAWN_ATTEMPTS.get(); ++i) {
            int k;
            int l;
            int j = pPos.m_123341_() + this.random.m_188503_(pMaxDistance * 2) - pMaxDistance;
            BlockPos blockpos1 = new BlockPos(j, l = pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = pPos.m_123343_() + this.random.m_188503_(pMaxDistance * 2) - pMaxDistance), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)pLevel, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(BlockGetter pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos, (BlockPos)pPos.m_7918_(1, 2, 1))) {
            if (pLevel.m_8055_(blockpos).m_60812_(pLevel, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

