/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies.init;

import com.nyfaria.perfectplushieapi.block.PlushieBlock;
import com.nyfaria.perfectplushieapi.item.ColoredPlushieBlockItem;
import com.nyfaria.perfectplushieapi.item.PlayerGeoPlushieBlockItem;
import io.github.sirjain0.perfectplushies.block.DumboBlobPlushieBlock;
import io.github.sirjain0.perfectplushies.block.PPPlayerPlushieBlock;
import io.github.sirjain0.perfectplushies.block.RubberDuckPlushieBlock;
import io.github.sirjain0.perfectplushies.block.entity.PPDualColorBlockEntity;
import io.github.sirjain0.perfectplushies.block.entity.PPPlayerPlushieBE;
import io.github.sirjain0.perfectplushies.init.ItemInit;
import io.github.sirjain0.perfectplushies.registration.RegistrationProvider;
import io.github.sirjain0.perfectplushies.registration.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BlockInit<T extends Block> {
    public static final RegistrationProvider<Block> BLOCKS = RegistrationProvider.get(Registries.f_256747_, "perfectplushies");
    public static final RegistrationProvider<BlockEntityType<?>> BLOCK_ENTITIES = RegistrationProvider.get(Registries.f_256922_, "perfectplushies");
    public static List<RegistryObject<Block>> playerBlocks = new ArrayList<RegistryObject<Block>>();
    public static List<RegistryObject<Block>> playerBlocksCommon = new ArrayList<RegistryObject<Block>>();
    public static List<RegistryObject<Block>> playerBlocksRare = new ArrayList<RegistryObject<Block>>();
    public static List<RegistryObject<Block>> playerBlocksEpic = new ArrayList<RegistryObject<Block>>();
    public static List<RegistryObject<? extends Block>> plushieBlocks = new ArrayList<RegistryObject<? extends Block>>();
    public static final RegistryObject<Block> NYF_PLUSHIE = BlockInit.registerCommonPlayerPlushie("nyf_plushie");
    public static final RegistryObject<Block> SIRJAIN_PLUSHIE = BlockInit.registerCommonPlayerPlushie("sirjain_plushie");
    public static final RegistryObject<Block> SIZABLESHRIMP_PLUSHIE = BlockInit.registerCommonPlayerPlushie("sizableshrimp_plushie");
    public static final RegistryObject<Block> TSLAT_PLUSHIE = BlockInit.registerCommonPlayerPlushie("tslat_plushie");
    public static final RegistryObject<Block> SILK_PLUSHIE = BlockInit.registerCommonPlayerPlushie("silk_plushie");
    public static final RegistryObject<Block> JUNE_PLUSHIE = BlockInit.registerCommonPlayerPlushie("june_plushie");
    public static final RegistryObject<Block> DANIEL_PLUSHIE = BlockInit.registerCommonPlayerPlushie("daniel_plushie");
    public static final RegistryObject<Block> GAMERPOTION_PLUSHIE = BlockInit.registerCommonPlayerPlushie("gamerpotion_plushie");
    public static final RegistryObject<Block> JOOSH_PLUSHIE = BlockInit.registerCommonPlayerPlushie("joosh_plushie");
    public static final RegistryObject<Block> ROCRIS_PLUSHIE = BlockInit.registerCommonPlayerPlushie("rocris_plushie");
    public static final RegistryObject<Block> GEODE_PLUSHIE = BlockInit.registerCommonPlayerPlushie("geode_plushie");
    public static final RegistryObject<Block> GAMERPOTION_PLUSHIE_RARE = BlockInit.registerRarePlayerPlushie("gamerpotion_plushie_rare");
    public static final RegistryObject<Block> SIRJAIN_PLUSHIE_RARE = BlockInit.registerRarePlayerPlushie("sirjain_plushie_rare");
    public static final RegistryObject<Block> RED_FOX_PLUSHIE = BlockInit.registerCommonBasicPlushie("red_fox_plushie");
    public static final RegistryObject<Block> SNOW_FOX_PLUSHIE = BlockInit.registerCommonBasicPlushie("snow_fox_plushie");
    public static final RegistryObject<Block> FENNEC_FOX_PLUSHIE = BlockInit.registerCommonBasicPlushie("fennec_fox_plushie");
    public static final RegistryObject<Block> RACCOON_PLUSHIE = BlockInit.registerCommonBasicPlushie("raccoon_plushie");
    public static final RegistryObject<Block> RED_PANDA_PLUSHIE = BlockInit.registerCommonBasicPlushie("red_panda_plushie");
    public static final RegistryObject<Block> RED_RUFFED_LEMUR_PLUSHIE = BlockInit.registerCommonBasicPlushie("red_ruffed_lemur_plushie");
    public static final RegistryObject<Block> CAPYBARA_PLUSHIE = BlockInit.registerCommonBasicPlushie("capybara_plushie");
    public static final RegistryObject<Block> DOG_PLUSHIE = BlockInit.registerCommonBasicPlushie("dog_plushie");
    public static final RegistryObject<Block> CAT_PLUSHIE = BlockInit.registerCommonBasicPlushie("cat_plushie");
    public static final RegistryObject<Block> DOLPHIN_PLUSHIE = BlockInit.registerCommonBasicPlushie("dolphin_plushie");
    public static final RegistryObject<Block> BROWN_RABBIT_PLUSHIE = BlockInit.registerCommonBasicPlushie("brown_rabbit_plushie");
    public static final RegistryObject<Block> WHITE_RABBIT_PLUSHIE = BlockInit.registerCommonBasicPlushie("white_rabbit_plushie");
    public static final RegistryObject<Block> FROG_PLUSHIE = BlockInit.registerCommonBasicPlushie("frog_plushie");
    public static final RegistryObject<Block> GOOSE_PLUSHIE = BlockInit.registerCommonBasicPlushie("goose_plushie");
    public static final RegistryObject<Block> DUCK_PLUSHIE = BlockInit.registerCommonBasicPlushie("duck_plushie");
    public static final RegistryObject<Block> RUBBER_DUCK_PLUSHIE = BlockInit.registerCustomPlushie("rubber_duck_plushie", RubberDuckPlushieBlock::new);
    public static final RegistryObject<Block> ROBIN_PLUSHIE = BlockInit.registerCommonBasicPlushie("robin_plushie");
    public static final RegistryObject<Block> HUMMINGBIRD_PLUSHIE = BlockInit.registerCommonBasicPlushie("hummingbird_plushie");
    public static final RegistryObject<Block> HIPPO_PLUSHIE = BlockInit.registerCommonBasicPlushie("hippo_plushie");
    public static final RegistryObject<Block> MOUSE_PLUSHIE = BlockInit.registerCommonBasicPlushie("mouse_plushie");
    public static final RegistryObject<Block> TURTLE_PLUSHIE = BlockInit.registerCommonBasicPlushie("turtle_plushie");
    public static final RegistryObject<Block> DOE_PLUSHIE = BlockInit.registerCommonBasicPlushie("doe_plushie");
    public static final RegistryObject<Block> REINDEER_PLUSHIE = BlockInit.registerCommonBasicPlushie("reindeer_plushie");
    public static final RegistryObject<Block> BEAR_PLUSHIE = BlockInit.registerCommonBasicPlushie("bear_plushie");
    public static final RegistryObject<Block> KOALA_PLUSHIE = BlockInit.registerCommonBasicPlushie("koala_plushie");
    public static final RegistryObject<Block> PANDA_PLUSHIE = BlockInit.registerCommonBasicPlushie("panda_plushie");
    public static final RegistryObject<Block> LION_CUB_PLUSHIE = BlockInit.registerCommonBasicPlushie("lion_cub_plushie");
    public static final RegistryObject<Block> ELEPHANT_PLUSHIE = BlockInit.registerCommonBasicPlushie("elephant_plushie");
    public static final RegistryObject<Block> MONKEY_PLUSHIE = BlockInit.registerCommonBasicPlushie("monkey_plushie");
    public static final RegistryObject<Block> SEAL_PLUSHIE = BlockInit.registerCommonBasicPlushie("seal_plushie");
    public static final RegistryObject<Block> HEDGEHOG_PLUSHIE = BlockInit.registerCommonBasicPlushie("hedgehog_plushie");
    public static final RegistryObject<Block> AYE_AYE_PLUSHIE = BlockInit.registerCommonBasicPlushie("aye_aye_plushie");
    public static final RegistryObject<Block> QUOKKA_PLUSHIE = BlockInit.registerCommonBasicPlushie("quokka_plushie");
    public static final RegistryObject<Block> DUMBO_BLOB_PLUSHIE = BlockInit.registerCustomItemPlushie("dumbo_blob_plushie", DumboBlobPlushieBlock::new, block -> () -> new ColoredPlushieBlockItem((Block)block.get(), Rarity.RARE));
    public static final RegistryObject<BlockEntityType<PPPlayerPlushieBE>> PLAYER_PLUSHIE_BLOCK_ENTITY = BLOCK_ENTITIES.register("player_plushie_block_entity", () -> BlockEntityType.Builder.m_155273_(PPPlayerPlushieBE::new, (Block[])((Block[])playerBlocks.stream().map(Supplier::get).toArray(Block[]::new))).m_58966_(null));
    public static final RegistryObject<BlockEntityType<PPDualColorBlockEntity>> PP_COLOR_BLOCK_ENTITY = BLOCK_ENTITIES.register("dumbo_blob_plushie", () -> BlockEntityType.Builder.m_155273_(PPDualColorBlockEntity::new, (Block[])new Block[]{DUMBO_BLOB_PLUSHIE.get()}).m_58966_(null));

    public static RegistryObject<Block> registerCommonPlayerPlushie(String name) {
        return BlockInit.registerPlayerPlushie(name, Rarity.COMMON);
    }

    public static RegistryObject<Block> registerRarePlayerPlushie(String name) {
        return BlockInit.registerPlayerPlushie(name, Rarity.RARE);
    }

    public static RegistryObject<Block> registerEpicPlayerPlushie(String name) {
        return BlockInit.registerPlayerPlushie(name, Rarity.EPIC);
    }

    public static RegistryObject<Block> registerPlayerPlushie(String name, Rarity rarity) {
        RegistryObject<Block> block = BLOCKS.register(name, PPPlayerPlushieBlock::new);
        ItemInit.ITEMS.register(name, () -> new PlayerGeoPlushieBlockItem((Block)block.get(), rarity));
        BlockInit.addToList(block, rarity);
        return block;
    }

    public static void addToList(RegistryObject<Block> block, Rarity rarity) {
        switch (rarity) {
            case COMMON: {
                playerBlocksCommon.add(block);
                break;
            }
            case RARE: {
                playerBlocksRare.add(block);
                break;
            }
            case EPIC: {
                playerBlocksEpic.add(block);
            }
        }
        playerBlocks.add(block);
    }

    public static RegistryObject<Block> registerCommonBasicPlushie(String name) {
        return BlockInit.registerBasicPlushie(name, Rarity.COMMON);
    }

    public static RegistryObject<Block> registerRareBasicPlushie(String name) {
        return BlockInit.registerBasicPlushie(name, Rarity.RARE);
    }

    public static RegistryObject<Block> registerEpicBasicPlushie(String name) {
        return BlockInit.registerBasicPlushie(name, Rarity.EPIC);
    }

    public static RegistryObject<Block> registerBasicPlushie(String name, Rarity rarity) {
        RegistryObject<Block> block = BLOCKS.register(name, PlushieBlock::new);
        ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity)));
        plushieBlocks.add(block);
        return block;
    }

    public static RegistryObject<Block> registerCustomPlushie(String name, Supplier<? extends Block> customPlushieBlock) {
        RegistryObject<Block> block = BLOCKS.register(name, customPlushieBlock);
        ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(Rarity.COMMON)));
        plushieBlocks.add(block);
        return block;
    }

    public static <T extends Block> RegistryObject<T> registerCustomItemPlushie(String name, Supplier<T> customPlushieBlock, Function<RegistryObject<T>, Supplier<? extends BlockItem>> item) {
        RegistryObject block = BLOCKS.register(name, customPlushieBlock);
        ItemInit.ITEMS.register(name, () -> (BlockItem)((Supplier)item.apply(block)).get());
        return block;
    }

    public static void loadClass() {
    }
}

