/*
 * Decompiled with CFR 0.152.
 */
package io.github.sirjain0.perfectplushies.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class VillageLootModifier
extends LootModifier {
    public static final Codec<VillageLootModifier> CODEC = RecordCodecBuilder.create(builder -> VillageLootModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)TagEntry.f_215911_.listOf().fieldOf("plushies").forGetter(VillageLootModifier::plushies)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(VillageLootModifier::chance)).apply((Applicative)builder, VillageLootModifier::new));
    public final List<TagEntry> plushies;
    private final float chance;

    protected VillageLootModifier(LootItemCondition[] conditionsIn, List<TagEntry> plushies, float chance) {
        super(conditionsIn);
        this.plushies = plushies;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_188501_() < this.chance) {
            Item item;
            TagEntry tagthing = this.plushies.get(context.m_230907_().m_188503_(this.plushies.size()));
            if (tagthing.isTag()) {
                TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagthing.getId());
                item = (Item)ForgeRegistries.ITEMS.tags().getTag(itemTag).getRandomElement(context.m_230907_()).get();
            } else {
                item = (Item)ForgeRegistries.ITEMS.getValue(tagthing.getId());
            }
            generatedLoot.add((Object)new ItemStack((ItemLike)item));
        }
        return generatedLoot;
    }

    public List<TagEntry> plushies() {
        return this.plushies;
    }

    public float chance() {
        return this.chance;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

