#version 150

#moj_import <fog.glsl>
#moj_import <warm_smoke/colour_conversions.glsl>
#moj_import <warm_smoke/colour_test.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec2 texCoord0;
in vec4 vertexColor;

in vec3 cornerUV1; // for warm_smoke
in vec3 cornerUV2;
in vec3 cornerUV3;

out vec4 fragColor;

void main() {
    #moj_import <warm_smoke/smoke_logic.glsl>

    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
    if (color.a < 0.1) {
        discard;
    }

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
