#version 150

#moj_import <fog.glsl>

in vec3 Position;
in vec2 UV0;
in vec4 Color;
in ivec2 UV2;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform int FogShape;

out float vertexDistance;
out vec2 texCoord0;
out vec4 vertexColor;

out vec3 cornerUV1;  // for warm_smoke
out vec3 cornerUV2;
out vec3 cornerUV3;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);

     // for warm_smoke
    int id = gl_VertexID % 4;
    cornerUV1 = cornerUV2 = cornerUV3 = vec3(0);
    switch (id) {
        case 0: cornerUV1 = vec3(UV0.xy,1); break;
        case 1: cornerUV2 = vec3(UV0.xy,1); break;
        case 2: cornerUV3 = vec3(UV0.xy,1); break;
    }

    vertexDistance = fog_distance(ModelViewMat, Position, FogShape);
    texCoord0 = UV0;
    vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);
}
