// Shader written by Enchanted Games (https://enchanted.games)
// Please do not re-upload this without permission

vec2 cornerUV1 = cornerUV1.xy / cornerUV1.z;
vec2 cornerUV2 = cornerUV2.xy / cornerUV2.z;
vec2 cornerUV3 = cornerUV3.xy / cornerUV3.z;
vec2 minUV = min(cornerUV1, min(cornerUV2, cornerUV3));
vec2 maxUV = max(cornerUV1, max(cornerUV2, cornerUV3));

// specific colour the shader looks for in the top left and bottom right corners
// of the particle texture to determine if rendering smoke particles
vec4 smokeMarkerColour = vec4(0.0471, 0.0431, 0.0392, 0.0353);

if( rougheq(texture(Sampler0, minUV + 0.001), smokeMarkerColour) || rougheq(texture(Sampler0, maxUV - 0.001), smokeMarkerColour) ) {
  vec4 textureCol = texture(Sampler0, texCoord0);

  // convert to hsl
  vec3 HSLCol = RGBtoHSL(textureCol.rgb);

  // adjust saturation based on vertex opacity
  float sat = vertexColor.a * vertexColor.a * vertexColor.a;
  sat += 0.1;
  sat *= 1.3;
  HSLCol.g *= clamp(sat, 0, 1);

  // convert back to rgb
  vec4 finalCol = vec4(HSLtoRGB(HSLCol), textureCol.a);

  if (finalCol.a < 0.1) {
      discard;
  }
  fragColor = finalCol * vec4(vertexColor.rgb, clamp(vertexColor.a * 9, 0, 1) - 0.15 ) * ColorModulator;

  return;
}