// --- Constants ---
const MOB_LIMIT = 50; // Limit for the number of mobs to be killed
const MOBS = [
    "minecraft:zombie",
    "minecraft:skeleton",
    "minecraft:creeper",
    "minecraft:phantom",
    "minecraft:enderman",
    "minecraft:slime",
    "minecraft:witch",
    "minecraft:spider"
];

const DISCORD_LINK = "https://discord.gg/sYSeMPR5uk";  // Discord invite link
const HOSTING_LINK = "https://mysticlouds.com";  // Hosting link

PlayerEvents.chat(event => {
    if (event.message.trim().toLowerCase() === 'creeper') {
        event.server.scheduleInTicks(3, () => {
            event.server.runCommand(`tellraw @a {"text":"Aw man","color":"green"}`);
        });
    }

    // Respond to !discord command
    if (event.message.trim().toLowerCase() === '!discord') {
        event.server.scheduleInTicks(3, () => {  // Delay before responding
            event.server.runCommand(`tellraw @a {"text":"Join our Discord: ${DISCORD_LINK}","color":"blue","clickEvent":{"action":"open_url","value":"${DISCORD_LINK}"}}`);
        });
    }

    // Respond to !hosting command
    if (event.message.trim().toLowerCase() === '!hosting') {
        event.server.scheduleInTicks(3, () => {  // Delay before responding
            event.server.runCommand(`tellraw @a {"text":"Hosting provided by: ${HOSTING_LINK}","color":"blue","clickEvent":{"action":"open_url","value":"${HOSTING_LINK}"}}`);
        });
    }
});

// --- Mob Limit Cleanup Command ---
ServerEvents.commandRegistry(event => {
    const LIMIT_MOBS_COMMAND_NAME = "limitmobs";
    const { commands: Commands } = event;

    function limitMobs(server) {
        MOBS.forEach(mob => {
            server.runCommand(`kill @e[type=${mob},limit=${MOB_LIMIT},sort=furthest]`);
        });
        return 1;
    }

    event.register(
        Commands.literal(LIMIT_MOBS_COMMAND_NAME)
            .executes(c => limitMobs(c.source.server))
    );
});

// --- Server Restart Notifications ---
ServerEvents.commandRegistry(event => {
    const RESTART_COMMAND_NAME = "restartserver";
    const { commands: Commands } = event;

    function scheduleRestart(server) {
        // Notify for restart in 5 minutes with title and subtitle
        server.runCommand(`title @a title {"text":"!Server restart!","color":"red"}`);
        server.runCommand(`title @a subtitle {"text":"Time remaining: 5 minutes","color":"gray"}`);

        // Notify for restart in 1 minute with title and subtitle
        server.schedule(4 * MINUTE, () => { 
            server.runCommand(`title @a title {"text":"!Server restart!","color":"red"}`);
            server.runCommand(`title @a subtitle {"text":"Time remaining: 1 minute","color":"gray"}`);
        });

        server.schedule(5 * MINUTE, () => {
            server.runCommand(`title @a actionbar {"text":"Restart in 5 seconds","color":"red"}`);
            server.schedule(1 * SECOND, () => {
                server.runCommand(`title @a actionbar {"text":"Restart in 4 seconds","color":"red"}`);
            });
            server.schedule(2 * SECOND, () => {
                server.runCommand(`title @a actionbar {"text":"Restart in 3 seconds","color":"red"}`);
            });
            server.schedule(3 * SECOND, () => {
                server.runCommand(`title @a actionbar {"text":"Restart in 2 seconds","color":"red"}`);
            });
            server.schedule(4 * SECOND, () => {
                server.runCommand(`title @a actionbar {"text":"Restart in 1 second","color":"red"}`);
            });
            server.schedule(5 * SECOND, () => {
                server.runCommand(`/stop`); // Stop the server
            });
        });

        return 1;
    }

    event.register(
        Commands.literal(RESTART_COMMAND_NAME)
            .executes(c => scheduleRestart(c.source.server))
    );
});

// --- Gamerules Setup on Server Load ---
ServerEvents.loaded(event => {
    event.server.runCommand(`gamerule playersSleepPercentage 0`);  // Set 1-player sleep
    event.server.runCommand(`gamerule doFireTick false`);          // Disable fire spread
});
